/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.math.BigInteger;
import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.ldap.common.NotImplementedException;
import org.apache.ldap.common.filter.AssertionNode;
import org.apache.ldap.common.filter.BranchNode;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.LeafNode;
import org.apache.ldap.common.filter.PresenceNode;
import org.apache.ldap.common.filter.ScopeNode;
import org.apache.ldap.common.filter.SimpleNode;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.DisjunctionEnumeration;
import org.apache.ldap.server.db.Enumerator;
import org.apache.ldap.server.db.ExpressionEvaluator;
import org.apache.ldap.server.db.Index;
import org.apache.ldap.server.db.IndexAssertion;
import org.apache.ldap.server.db.IndexAssertionEnumeration;
import org.apache.ldap.server.db.IndexEnumeration;
import org.apache.ldap.server.db.IndexRecord;
import org.apache.ldap.server.db.LeafEvaluator;
import org.apache.ldap.server.db.ScopeEnumerator;
import org.apache.ldap.server.db.SubstringEnumerator;
import org.apache.ldap.server.schema.AttributeTypeRegistry;

public class ExpressionEnumerator
implements Enumerator {
    private Database db = null;
    private ScopeEnumerator scopeEnumerator;
    private SubstringEnumerator substringEnumerator;
    private ExpressionEvaluator evaluator;

    public ExpressionEnumerator(Database db, AttributeTypeRegistry attributeTypeRegistry, ExpressionEvaluator evaluator) {
        this.db = db;
        this.evaluator = evaluator;
        LeafEvaluator leafEvaluator = evaluator.getLeafEvaluator();
        this.scopeEnumerator = new ScopeEnumerator(db, leafEvaluator.getScopeEvaluator());
        this.substringEnumerator = new SubstringEnumerator(db, attributeTypeRegistry, leafEvaluator.getSubstringEvaluator());
    }

    public NamingEnumeration enumerate(ExprNode node) throws NamingException {
        NamingEnumeration list;
        block16: {
            block17: {
                block15: {
                    list = null;
                    if (!(node instanceof ScopeNode)) break block15;
                    list = this.scopeEnumerator.enumerate(node);
                    break block16;
                }
                if (node instanceof AssertionNode) {
                    throw new IllegalArgumentException("Cannot produce enumeration on an AssertionNode");
                }
                if (!node.isLeaf()) break block17;
                LeafNode leaf = (LeafNode)node;
                switch (leaf.getAssertionType()) {
                    case 5: {
                        list = this.enumEquality((SimpleNode)node);
                        break block16;
                    }
                    case 0: {
                        list = this.enumEquality((SimpleNode)node);
                        break block16;
                    }
                    case 6: {
                        throw new NotImplementedException();
                    }
                    case 3: {
                        list = this.enumGreater((SimpleNode)node, true);
                        break block16;
                    }
                    case 4: {
                        list = this.enumGreater((SimpleNode)node, false);
                        break block16;
                    }
                    case 1: {
                        list = this.enumPresence((PresenceNode)node);
                        break block16;
                    }
                    case 2: {
                        list = this.substringEnumerator.enumerate(leaf);
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown leaf assertion");
                    }
                }
            }
            BranchNode branch = (BranchNode)node;
            switch (branch.getOperator()) {
                case 10: {
                    list = this.enumConj(branch);
                    break;
                }
                case 11: {
                    list = this.enumNeg(branch);
                    break;
                }
                case 9: {
                    list = this.enumDisj(branch);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown branch logical operator");
                }
            }
        }
        return list;
    }

    private NamingEnumeration enumDisj(BranchNode node) throws NamingException {
        ArrayList children = node.getChildren();
        NamingEnumeration[] childEnumerations = new NamingEnumeration[children.size()];
        int ii = 0;
        while (ii < childEnumerations.length) {
            childEnumerations[ii] = this.enumerate((ExprNode)children.get(ii));
            ++ii;
        }
        return new DisjunctionEnumeration(childEnumerations);
    }

    private NamingEnumeration enumNeg(final BranchNode node) throws NamingException {
        Index idx = null;
        IndexEnumeration childEnumeration = null;
        IndexAssertionEnumeration enumeration = null;
        if (node.getChild().isLeaf()) {
            LeafNode child = (LeafNode)node.getChild();
            idx = this.db.getUserIndex(child.getAttribute());
            childEnumeration = idx.listIndices();
        } else {
            idx = this.db.getNdnIndex();
            childEnumeration = idx.listIndices();
        }
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                return !ExpressionEnumerator.this.evaluator.evaluate(node.getChild(), rec);
            }
        };
        enumeration = new IndexAssertionEnumeration(childEnumeration, assertion, true);
        return enumeration;
    }

    private NamingEnumeration enumConj(BranchNode node) throws NamingException {
        int minIndex = 0;
        int minValue = Integer.MAX_VALUE;
        int value = Integer.MAX_VALUE;
        final ArrayList children = node.getChildren();
        int ii = 0;
        while (ii < children.size()) {
            ExprNode child = (ExprNode)children.get(ii);
            value = ((BigInteger)child.get("count")).intValue();
            if ((minValue = Math.min(minValue, value)) == value) {
                minIndex = ii;
            }
            ++ii;
        }
        final ExprNode minChild = (ExprNode)children.get(minIndex);
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                int ii = 0;
                while (ii < children.size()) {
                    ExprNode child = (ExprNode)children.get(ii);
                    if (child != minChild && !ExpressionEnumerator.this.evaluator.evaluate(child, rec)) {
                        return false;
                    }
                    ++ii;
                }
                return true;
            }
        };
        NamingEnumeration underlying = this.enumerate(minChild);
        IndexAssertionEnumeration iae = new IndexAssertionEnumeration(underlying, assertion);
        return iae;
    }

    private NamingEnumeration enumPresence(PresenceNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getExistanceIndex();
            return idx.listIndices(node.getAttribute());
        }
        return this.nonIndexedScan(node);
    }

    private NamingEnumeration enumGreater(SimpleNode node, boolean isGreater) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            if (isGreater) {
                return idx.listIndices(node.getValue(), true);
            }
            return idx.listIndices(node.getValue(), false);
        }
        return this.nonIndexedScan(node);
    }

    private NamingEnumeration enumEquality(SimpleNode node) throws NamingException {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index idx = this.db.getUserIndex(node.getAttribute());
            return idx.listIndices(node.getValue());
        }
        return this.nonIndexedScan(node);
    }

    private NamingEnumeration nonIndexedScan(final LeafNode node) throws NamingException {
        IndexEnumeration underlying = this.db.getNdnIndex().listIndices();
        IndexAssertion assertion = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord record) throws NamingException {
                return ExpressionEnumerator.this.evaluator.getLeafEvaluator().evaluate(node, record);
            }
        };
        return new IndexAssertionEnumeration(underlying, assertion);
    }
}

