/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.server.db.SearchResultFilter;

public class ResultFilteringEnumeration
implements NamingEnumeration {
    private final List filters;
    private final NamingEnumeration decorated;
    private SearchResult prefetched;
    private boolean isClosed = false;
    private final SearchControls searchControls;
    private final LdapContext ctx;

    public ResultFilteringEnumeration(NamingEnumeration decorated, SearchControls searchControls, LdapContext ctx, SearchResultFilter filter) throws NamingException {
        this.searchControls = searchControls;
        this.ctx = ctx;
        this.filters = new ArrayList();
        this.filters.add(filter);
        this.decorated = decorated;
        if (!decorated.hasMore()) {
            this.close();
            return;
        }
        this.prefetch();
    }

    public ResultFilteringEnumeration(NamingEnumeration decorated, SearchControls searchControls, LdapContext ctx, List filters) throws NamingException {
        this.searchControls = searchControls;
        this.ctx = ctx;
        this.filters = new ArrayList();
        this.filters.addAll(filters);
        this.decorated = decorated;
        if (!decorated.hasMore()) {
            this.close();
            return;
        }
        this.prefetch();
    }

    public boolean addResultFilter(SearchResultFilter filter) {
        return this.filters.add(filter);
    }

    public boolean removeResultFilter(SearchResultFilter filter) {
        return this.filters.remove(filter);
    }

    public List getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void close() throws NamingException {
        this.isClosed = true;
        this.decorated.close();
    }

    public boolean hasMore() {
        return !this.isClosed;
    }

    public Object next() throws NamingException {
        SearchResult retVal = this.prefetched;
        this.prefetch();
        return retVal;
    }

    public boolean hasMoreElements() {
        return !this.isClosed;
    }

    public Object nextElement() {
        SearchResult retVal = this.prefetched;
        try {
            this.prefetch();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private void prefetch() throws NamingException {
        SearchResult tmp = null;
        while (this.decorated.hasMore()) {
            boolean accepted = true;
            tmp = (SearchResult)this.decorated.next();
            if (this.filters.isEmpty()) {
                this.prefetched = tmp;
                return;
            }
            if (this.filters.size() == 1) {
                accepted = ((SearchResultFilter)this.filters.get(0)).accept(this.ctx, tmp, this.searchControls);
                if (!accepted) continue;
                this.prefetched = tmp;
                return;
            }
            int ii = 0;
            while (ii < this.filters.size()) {
                SearchResultFilter filter = (SearchResultFilter)this.filters.get(ii);
                if (!(accepted &= filter.accept(this.ctx, tmp, this.searchControls))) {
                    // empty if block
                }
                ++ii;
            }
            this.prefetched = tmp;
            return;
        }
        this.close();
    }
}

