/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.db;

import java.math.BigInteger;
import javax.naming.NamingException;
import org.apache.ldap.common.filter.ExprNode;
import org.apache.ldap.common.filter.ScopeNode;
import org.apache.ldap.common.message.DerefAliasesEnum;
import org.apache.ldap.server.db.Database;
import org.apache.ldap.server.db.Evaluator;
import org.apache.ldap.server.db.Index;
import org.apache.ldap.server.db.IndexRecord;

public class ScopeEvaluator
implements Evaluator {
    private Database db;

    public ScopeEvaluator(Database db) {
        this.db = db;
    }

    public boolean evaluate(ExprNode node, IndexRecord record) throws NamingException {
        ScopeNode snode = (ScopeNode)node;
        switch (snode.getScope()) {
            case 0: {
                String dn = this.db.getEntryDn(record.getEntryId());
                return dn.equals(snode.getBaseDn());
            }
            case 1: {
                return this.assertOneLevelScope(snode, record.getEntryId());
            }
            case 2: {
                return this.assertSubtreeScope(snode, record.getEntryId());
            }
        }
        throw new NamingException("Unrecognized search scope!");
    }

    public boolean assertSubtreeScope(ScopeNode node, BigInteger id) throws NamingException {
        String dn = this.db.getEntryDn(id);
        DerefAliasesEnum mode = node.getDerefAliases();
        BigInteger baseId = this.db.getEntryId(node.getBaseDn());
        boolean isDescendant = dn.endsWith(node.getBaseDn());
        if (!mode.derefInSearching()) {
            return isDescendant;
        }
        Index idx = this.db.getAliasIndex();
        if (idx.reverseLookup(id) != null) {
            return false;
        }
        if (isDescendant) {
            return true;
        }
        idx = this.db.getSubAliasIndex();
        return idx.hasValue(baseId, id);
    }

    public boolean assertOneLevelScope(ScopeNode node, BigInteger id) throws NamingException {
        DerefAliasesEnum mode = node.getDerefAliases();
        BigInteger baseId = this.db.getEntryId(node.getBaseDn());
        Index idx = this.db.getHierarchyIndex();
        boolean isChild = idx.hasValue(baseId, id);
        if (!mode.derefInSearching()) {
            return isChild;
        }
        idx = this.db.getAliasIndex();
        if (idx.reverseLookup(id) != null) {
            return false;
        }
        if (isChild) {
            return true;
        }
        idx = this.db.getOneAliasIndex();
        return idx.hasValue(baseId, id);
    }
}

