/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.interceptor;

import org.apache.ldap.common.exception.LdapException;
import org.apache.ldap.common.exception.LdapNamingException;
import org.apache.ldap.common.message.ResultCodeEnum;
import org.apache.ldap.server.interceptor.Interceptor;
import org.apache.ldap.server.invocation.Invocation;

public class InterceptorException
extends LdapNamingException {
    private static final long serialVersionUID = 3258690996517746233L;
    private final Invocation invocation;
    private final Interceptor interceptor;

    public InterceptorException(Interceptor interceptor, Invocation invocation) {
        super(ResultCodeEnum.OTHER);
        this.invocation = invocation;
        this.interceptor = interceptor;
    }

    public InterceptorException(Interceptor interceptor, Invocation invocation, String explanation) {
        super(explanation, ResultCodeEnum.OTHER);
        this.invocation = invocation;
        this.interceptor = interceptor;
    }

    public InterceptorException(Interceptor interceptor, Invocation invocation, Throwable rootCause) {
        this(interceptor, invocation);
        super.setRootCause(rootCause);
    }

    public InterceptorException(Interceptor interceptor, Invocation invocation, String explanation, Throwable rootCause) {
        this(interceptor, invocation, explanation);
        super.setRootCause(rootCause);
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public ResultCodeEnum getResultCode() {
        if (this.getRootCause() != null && this.getRootCause() instanceof LdapException) {
            return ((LdapException)((Object)this.getRootCause())).getResultCode();
        }
        return super.getResultCode();
    }
}

