/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.prefs;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.ldap.common.Lockable;
import org.apache.ldap.common.message.LockableAttributeImpl;
import org.apache.ldap.common.message.LockableAttributesImpl;
import org.apache.ldap.common.util.PreferencesDictionary;

public class ServerSystemPreferences
extends AbstractPreferences {
    private static final ModificationItem[] EMPTY_MODS = new ModificationItem[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private LdapContext ctx;
    private ArrayList changes = new ArrayList(3);
    private HashMap keyToChange = new HashMap(3);
    static /* synthetic */ Class class$0;

    public ServerSystemPreferences() {
        super(null, "");
        this.newNode = false;
        Hashtable<String, String> env = new Hashtable<String, String>();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ldap.server.jndi.CoreContextFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        env.put("java.naming.factory.initial", clazz.getName());
        env.put("java.naming.provider.url", "prefNodeName=sysPrefRoot,ou=system");
        try {
            this.ctx = new InitialLdapContext(env, null);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public ServerSystemPreferences(ServerSystemPreferences parent, String name) {
        super(parent, name);
        LdapContext parentCtx = parent.getLdapContext();
        try {
            this.ctx = (LdapContext)parentCtx.lookup("prefNodeName=" + name);
            this.newNode = false;
        }
        catch (NamingException namingException) {
            this.newNode = true;
        }
        if (this.newNode) {
            try {
                this.setUpNode(name);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }

    public Dictionary wrapAsDictionary() {
        return new PreferencesDictionary(this);
    }

    LdapContext getLdapContext() {
        return this.ctx;
    }

    private void setUpNode(String name) throws NamingException {
        LockableAttributesImpl attrs = new LockableAttributesImpl();
        LockableAttributeImpl attr = new LockableAttributeImpl((Lockable)attrs, "objectClass");
        attr.add("top");
        attr.add("prefNode");
        attr.add("extensibleObject");
        attrs.put(attr);
        attr = new LockableAttributeImpl((Lockable)attrs, "prefNodeName");
        attr.add(name);
        attrs.put(attr);
        LdapContext parent = ((ServerSystemPreferences)this.parent()).getLdapContext();
        parent.bind("prefNodeName=" + name, null, (Attributes)attrs);
        this.ctx = (LdapContext)parent.lookup("prefNodeName=" + name);
        this.newNode = false;
    }

    protected void flushSpi() throws BackingStoreException {
        if (this.ctx == null) {
            throw new BackingStoreException("Ldap context not available for " + super.absolutePath());
        }
        if (this.changes.isEmpty()) {
            return;
        }
        try {
            this.ctx.modifyAttributes("", this.changes.toArray(EMPTY_MODS));
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    protected void removeNodeSpi() throws BackingStoreException {
        try {
            this.ctx.destroySubcontext("");
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        this.ctx = null;
        this.changes.clear();
        this.keyToChange.clear();
    }

    protected void syncSpi() throws BackingStoreException {
        if (this.ctx == null) {
            throw new BackingStoreException("Ldap context not available for " + super.absolutePath());
        }
        if (this.changes.isEmpty()) {
            return;
        }
        try {
            this.ctx.modifyAttributes("", this.changes.toArray(EMPTY_MODS));
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        this.changes.clear();
        this.keyToChange.clear();
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        ArrayList<String> children = new ArrayList<String>();
        NamingEnumeration<NameClassPair> list = null;
        try {
            list = this.ctx.list("");
            while (list.hasMore()) {
                NameClassPair ncp = list.next();
                children.add(ncp.getName());
            }
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        return children.toArray(EMPTY_STRINGS);
    }

    protected String[] keysSpi() throws BackingStoreException {
        Attributes attrs = null;
        ArrayList<String> keys = new ArrayList<String>();
        try {
            attrs = this.ctx.getAttributes("");
            NamingEnumeration<String> ids = attrs.getIDs();
            while (ids.hasMore()) {
                String id = ids.next();
                if (id.equals("objectClass") || id.equals("prefNodeName")) continue;
                keys.add(id);
            }
        }
        catch (NamingException e) {
            throw new BackingStoreException(e);
        }
        return keys.toArray(EMPTY_STRINGS);
    }

    protected void removeSpi(String key) {
        BasicAttribute attr = new BasicAttribute(key);
        ModificationItem mi = new ModificationItem(3, attr);
        this.addDelta(mi);
    }

    private void addDelta(ModificationItem mi) {
        String key = mi.getAttribute().getID();
        List<ModificationItem> deltas = null;
        this.changes.add(mi);
        deltas = this.keyToChange.containsKey(key) ? (List)this.keyToChange.get(key) : new ArrayList<ModificationItem>();
        deltas.add(mi);
        this.keyToChange.put(key, deltas);
    }

    protected String getSpi(String key) {
        String value = null;
        try {
            Attribute attr = this.ctx.getAttributes("").get(key);
            if (this.keyToChange.containsKey(key)) {
                List mods = (List)this.keyToChange.get(key);
                int ii = 0;
                while (ii < mods.size()) {
                    ModificationItem mi = (ModificationItem)mods.get(ii);
                    attr = mi.getModificationOp() == 3 ? null : mi.getAttribute();
                    ++ii;
                }
            }
            if (attr == null) {
                return null;
            }
            value = (String)attr.get();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return value;
    }

    protected void putSpi(String key, String value) {
        BasicAttribute attr = new BasicAttribute(key);
        attr.add(value);
        ModificationItem mi = new ModificationItem(2, attr);
        this.addDelta(mi);
    }

    protected AbstractPreferences childSpi(String name) {
        return new ServerSystemPreferences(this, name);
    }
}

