/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema.bootstrap;

import org.apache.ldap.common.util.ArrayUtils;
import org.apache.ldap.server.schema.bootstrap.BootstrapSchema;
import org.apache.ldap.server.schema.bootstrap.ProducerTypeEnum;

public class AbstractBootstrapSchema
implements BootstrapSchema {
    protected static final String[] DEFAULT_DEPS = ArrayUtils.EMPTY_STRING_ARRAY;
    private static final String DEFAULT_OWNER = "uid=admin,ou=system";
    private static final String DEFAULT_SCHEMA_NAME = "default";
    private static final String DEFAULT_PACKAGE_NAME = "org.apache.ldap.server.schema.bootstrap";
    private final String owner;
    private final String schemaName;
    private final String packageName;
    private String[] dependencies;
    private transient String baseName;
    private transient String defaultBaseName;
    private transient String schemaNameCapped;

    protected AbstractBootstrapSchema(String schemaName) {
        this(null, schemaName, null, null);
    }

    protected AbstractBootstrapSchema(String owner, String schemaName) {
        this(owner, schemaName, null, null);
    }

    protected AbstractBootstrapSchema(String owner, String schemaName, String packageName) {
        this(owner, schemaName, packageName, null);
    }

    protected AbstractBootstrapSchema(String owner, String schemaName, String packageName, String[] dependencies) {
        this.owner = owner == null ? DEFAULT_OWNER : owner;
        this.schemaName = schemaName == null ? DEFAULT_SCHEMA_NAME : schemaName;
        this.packageName = packageName == null ? DEFAULT_PACKAGE_NAME : packageName;
        this.dependencies = dependencies == null ? ArrayUtils.EMPTY_STRING_ARRAY : dependencies;
        StringBuffer buf = new StringBuffer();
        buf.append(Character.toUpperCase(schemaName.charAt(0)));
        buf.append(schemaName.substring(1, schemaName.length()));
        this.schemaNameCapped = buf.toString();
        buf.setLength(0);
        buf.append(DEFAULT_PACKAGE_NAME);
        buf.append('.');
        buf.append(this.schemaNameCapped);
        this.defaultBaseName = buf.toString();
        buf.setLength(0);
        buf.append(packageName);
        buf.append('.');
        buf.append(this.schemaNameCapped);
        this.baseName = buf.toString();
    }

    public final String getOwner() {
        return this.owner;
    }

    public final String getSchemaName() {
        return this.schemaName;
    }

    public final String[] getDependencies() {
        return this.dependencies;
    }

    protected final void setDependencies(String[] dependencies) {
        this.dependencies = dependencies;
    }

    public String getBaseClassName() {
        return this.baseName;
    }

    public String getDefaultBaseClassName() {
        return this.defaultBaseName;
    }

    public String getFullClassName(ProducerTypeEnum type) {
        return this.baseName + type.getName();
    }

    public String getFullDefaultBaseClassName(ProducerTypeEnum type) {
        return this.defaultBaseName + type.getName();
    }

    public String getUnqualifiedClassName(ProducerTypeEnum type) {
        return this.schemaNameCapped + type.getName();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getUnqualifiedClassName() {
        return this.schemaNameCapped + "Schema";
    }
}

