/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema.bootstrap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.ldap.server.schema.AttributeTypeRegistryMonitor;
import org.apache.ldap.server.schema.AttributeTypeRegistryMonitorAdapter;
import org.apache.ldap.server.schema.OidRegistry;

public class BootstrapAttributeTypeRegistry
implements AttributeTypeRegistry {
    private final Map byOid = new HashMap();
    private final Map oidToSchema = new HashMap();
    private final OidRegistry oidRegistry;
    private AttributeTypeRegistryMonitor monitor;

    public BootstrapAttributeTypeRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
        this.monitor = new AttributeTypeRegistryMonitorAdapter();
    }

    public void setMonitor(AttributeTypeRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, AttributeType attributeType) throws NamingException {
        if (this.byOid.containsKey(attributeType.getOid())) {
            NamingException e = new NamingException("attributeType w/ OID " + attributeType.getOid() + " has already been registered!");
            this.monitor.registerFailed(attributeType, e);
            throw e;
        }
        String[] names = attributeType.getNames();
        int ii = 0;
        while (ii < names.length) {
            this.oidRegistry.register(names[ii], attributeType.getOid());
            ++ii;
        }
        this.oidToSchema.put(attributeType.getOid(), schema);
        this.byOid.put(attributeType.getOid(), attributeType);
        this.monitor.registered(attributeType);
    }

    public AttributeType lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            NamingException e = new NamingException("attributeType w/ OID " + id + " not registered!");
            this.monitor.lookupFailed(id, e);
            throw e;
        }
        AttributeType attributeType = (AttributeType)this.byOid.get(id);
        this.monitor.lookedUp(attributeType);
        return attributeType;
    }

    public boolean hasAttributeType(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException namingException) {
                return false;
            }
        }
        return false;
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.oidToSchema.containsKey(id = this.oidRegistry.getOid(id))) {
            return (String)this.oidToSchema.get(id);
        }
        throw new NamingException("OID " + id + " not found in oid to " + "schema name map!");
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }
}

