/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema.bootstrap;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.AttributeType;
import org.apache.ldap.common.schema.DITContentRule;
import org.apache.ldap.common.schema.DITStructureRule;
import org.apache.ldap.common.schema.MatchingRule;
import org.apache.ldap.common.schema.MatchingRuleUse;
import org.apache.ldap.common.schema.NameForm;
import org.apache.ldap.common.schema.Normalizer;
import org.apache.ldap.common.schema.ObjectClass;
import org.apache.ldap.common.schema.Syntax;
import org.apache.ldap.common.schema.SyntaxChecker;
import org.apache.ldap.server.jndi.ServerDirObjectFactory;
import org.apache.ldap.server.jndi.ServerDirStateFactory;
import org.apache.ldap.server.schema.AttributeTypeRegistry;
import org.apache.ldap.server.schema.ComparatorRegistry;
import org.apache.ldap.server.schema.DITContentRuleRegistry;
import org.apache.ldap.server.schema.DITStructureRuleRegistry;
import org.apache.ldap.server.schema.MatchingRuleRegistry;
import org.apache.ldap.server.schema.MatchingRuleUseRegistry;
import org.apache.ldap.server.schema.NameFormRegistry;
import org.apache.ldap.server.schema.NormalizerRegistry;
import org.apache.ldap.server.schema.ObjectClassRegistry;
import org.apache.ldap.server.schema.ObjectFactoryRegistry;
import org.apache.ldap.server.schema.StateFactoryRegistry;
import org.apache.ldap.server.schema.SyntaxCheckerRegistry;
import org.apache.ldap.server.schema.SyntaxRegistry;
import org.apache.ldap.server.schema.bootstrap.BootstrapProducer;
import org.apache.ldap.server.schema.bootstrap.BootstrapRegistries;
import org.apache.ldap.server.schema.bootstrap.BootstrapSchema;
import org.apache.ldap.server.schema.bootstrap.ProducerCallback;
import org.apache.ldap.server.schema.bootstrap.ProducerTypeEnum;

public class BootstrapSchemaLoader {
    private ThreadLocal schemas;
    private ThreadLocal registries;
    private final ProducerCallback cb = new ProducerCallback(){

        public void schemaObjectProduced(BootstrapProducer producer, String registryKey, Object schemaObject) throws NamingException {
            BootstrapSchemaLoader.this.register(producer.getType(), registryKey, schemaObject);
        }
    };

    public BootstrapSchemaLoader() {
        this.schemas = new ThreadLocal();
        this.registries = new ThreadLocal();
    }

    public final void load(String[] schemaClasses, BootstrapRegistries registries) throws NamingException {
        BootstrapSchema[] schemas = new BootstrapSchema[schemaClasses.length];
        HashMap<String, BootstrapSchema> loaded = new HashMap<String, BootstrapSchema>();
        HashMap<String, BootstrapSchema> notLoaded = new HashMap<String, BootstrapSchema>();
        int ii = 0;
        while (ii < schemas.length) {
            try {
                Class<?> schemaClass = Class.forName(schemaClasses[ii]);
                schemas[ii] = (BootstrapSchema)schemaClass.newInstance();
                notLoaded.put(schemas[ii].getSchemaName(), schemas[ii]);
            }
            catch (Exception e) {
                String msg = "problem loading/creating " + schemaClasses[ii];
                NamingException ne = new NamingException(msg);
                ne.setRootCause(e);
                throw ne;
            }
            ++ii;
        }
        BootstrapSchema schema = (BootstrapSchema)notLoaded.get("system");
        this.load(schema, registries);
        notLoaded.remove("system");
        loaded.put(schema.getSchemaName(), schema);
        Iterator list = notLoaded.values().iterator();
        while (list.hasNext()) {
            schema = (BootstrapSchema)list.next();
            this.loadDepsFirst(new Stack(), notLoaded, schema, registries);
            list = notLoaded.values().iterator();
        }
    }

    public final void loadDepsFirst(Stack beenthere, HashMap notLoaded, BootstrapSchema schema, BootstrapRegistries registries) throws NamingException {
        beenthere.push(schema.getSchemaName());
        String[] deps = schema.getDependencies();
        if (deps == null || deps.length == 0) {
            this.load(schema, registries);
            notLoaded.remove(schema.getSchemaName());
            beenthere.pop();
            return;
        }
        int ii = 0;
        while (ii < deps.length) {
            if (notLoaded.containsKey(deps[ii])) {
                BootstrapSchema dep = (BootstrapSchema)notLoaded.get(deps[ii]);
                if (beenthere.contains(dep.getSchemaName())) {
                    beenthere.push(dep.getSchemaName());
                    throw new NamingException("schema dependency cycle detected: " + beenthere);
                }
                this.loadDepsFirst(beenthere, notLoaded, dep, registries);
            }
            ++ii;
        }
        this.load(schema, registries);
        notLoaded.remove(schema.getSchemaName());
        beenthere.pop();
    }

    public final void load(BootstrapSchema schema, BootstrapRegistries registries) throws NamingException {
        this.registries.set(registries);
        this.schemas.set(schema);
        List producers = ProducerTypeEnum.list();
        int ii = 0;
        while (ii < producers.size()) {
            ProducerTypeEnum producerType = (ProducerTypeEnum)producers.get(ii);
            BootstrapProducer producer = this.getProducer(schema, producerType.getName());
            producer.produce(registries, this.cb);
            ++ii;
        }
    }

    private void register(ProducerTypeEnum type, String id, Object schemaObject) throws NamingException {
        BootstrapSchema schema = (BootstrapSchema)this.schemas.get();
        BootstrapRegistries registries = (BootstrapRegistries)this.registries.get();
        switch (type.getValue()) {
            case 0: {
                Normalizer normalizer = (Normalizer)schemaObject;
                NormalizerRegistry normalizerRegistry = registries.getNormalizerRegistry();
                normalizerRegistry.register(schema.getSchemaName(), id, normalizer);
                break;
            }
            case 1: {
                Comparator comparator = (Comparator)schemaObject;
                ComparatorRegistry comparatorRegistry = registries.getComparatorRegistry();
                comparatorRegistry.register(schema.getSchemaName(), id, comparator);
                break;
            }
            case 2: {
                SyntaxChecker syntaxChecker = (SyntaxChecker)schemaObject;
                SyntaxCheckerRegistry syntaxCheckerRegistry = registries.getSyntaxCheckerRegistry();
                syntaxCheckerRegistry.register(schema.getSchemaName(), id, syntaxChecker);
                break;
            }
            case 3: {
                Syntax syntax = (Syntax)schemaObject;
                SyntaxRegistry syntaxRegistry = registries.getSyntaxRegistry();
                syntaxRegistry.register(schema.getSchemaName(), syntax);
                break;
            }
            case 4: {
                MatchingRule matchingRule = (MatchingRule)schemaObject;
                MatchingRuleRegistry matchingRuleRegistry = registries.getMatchingRuleRegistry();
                matchingRuleRegistry.register(schema.getSchemaName(), matchingRule);
                break;
            }
            case 5: {
                AttributeType attributeType = (AttributeType)schemaObject;
                AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
                attributeTypeRegistry.register(schema.getSchemaName(), attributeType);
                break;
            }
            case 6: {
                ObjectClass objectClass = (ObjectClass)schemaObject;
                ObjectClassRegistry objectClassRegistry = registries.getObjectClassRegistry();
                objectClassRegistry.register(schema.getSchemaName(), objectClass);
                break;
            }
            case 7: {
                MatchingRuleUse matchingRuleUse = (MatchingRuleUse)schemaObject;
                MatchingRuleUseRegistry matchingRuleUseRegistry = registries.getMatchingRuleUseRegistry();
                matchingRuleUseRegistry.register(schema.getSchemaName(), matchingRuleUse);
                break;
            }
            case 8: {
                DITContentRule ditContentRule = (DITContentRule)schemaObject;
                DITContentRuleRegistry ditContentRuleRegistry = registries.getDitContentRuleRegistry();
                ditContentRuleRegistry.register(schema.getSchemaName(), ditContentRule);
                break;
            }
            case 9: {
                NameForm nameForm = (NameForm)schemaObject;
                NameFormRegistry nameFormRegistry = registries.getNameFormRegistry();
                nameFormRegistry.register(schema.getSchemaName(), nameForm);
                break;
            }
            case 10: {
                DITStructureRule ditStructureRule = (DITStructureRule)schemaObject;
                DITStructureRuleRegistry ditStructureRuleRegistry = registries.getDitStructureRuleRegistry();
                ditStructureRuleRegistry.register(schema.getSchemaName(), ditStructureRule);
                break;
            }
            case 11: {
                ServerDirStateFactory stateFactory = (ServerDirStateFactory)schemaObject;
                StateFactoryRegistry stateFactoryRegistry = registries.getStateFactoryRegistry();
                stateFactoryRegistry.register(stateFactory);
                break;
            }
            case 12: {
                ServerDirObjectFactory objectFactory = (ServerDirObjectFactory)schemaObject;
                ObjectFactoryRegistry objectFactoryRegistry = registries.getObjectFactoryRegistry();
                objectFactoryRegistry.register(objectFactory);
                break;
            }
            default: {
                throw new IllegalStateException("ProducerTypeEnum is broke!");
            }
        }
    }

    private BootstrapProducer getProducer(BootstrapSchema schema, String producerBase) throws NamingException {
        Class<?> clazz = null;
        boolean failedTargetLoad = false;
        String targetClassName = String.valueOf(schema.getBaseClassName()) + producerBase;
        try {
            clazz = Class.forName(targetClassName);
        }
        catch (ClassNotFoundException e) {
            failedTargetLoad = true;
            e.printStackTrace();
        }
        if (failedTargetLoad) {
            String defaultClassName = String.valueOf(schema.getDefaultBaseClassName()) + producerBase;
            try {
                clazz = Class.forName(defaultClassName);
            }
            catch (ClassNotFoundException e) {
                NamingException ne = new NamingException("Failed to load " + producerBase + " for " + schema.getSchemaName() + " schema using following classes: " + targetClassName + ", " + defaultClassName);
                ne.setRootCause(e);
                throw ne;
            }
        }
        try {
            return (BootstrapProducer)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("Failed to create " + clazz);
            ne.setRootCause(e);
            throw ne;
        }
        catch (InstantiationException e) {
            NamingException ne = new NamingException("Failed to create " + clazz);
            ne.setRootCause(e);
            throw ne;
        }
    }
}

