/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import java.nio.ByteBuffer;
import net.gleamynode.netty2.Message;
import net.gleamynode.netty2.MessageParseException;
import net.gleamynode.netty2.MessageRecognizer;
import org.apache.mina.examples.sumup.AddMessage;
import org.apache.mina.examples.sumup.ResultMessage;

public class SumUpMessageRecognizer
implements MessageRecognizer {
    public static final int CLIENT_MODE = 1;
    public static final int SERVER_MODE = 2;
    private int mode;

    public SumUpMessageRecognizer(int mode) {
        switch (mode) {
            case 1: 
            case 2: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid mode: " + mode);
            }
        }
    }

    public Message recognize(ByteBuffer buf) throws MessageParseException {
        if (buf.remaining() < 2) {
            return null;
        }
        short type = buf.getShort();
        switch (this.mode) {
            case 2: {
                switch (type) {
                    case 1: {
                        return new AddMessage();
                    }
                }
                throw new MessageParseException("unknown type: " + type);
            }
            case 1: {
                switch (type) {
                    case 0: {
                        return new ResultMessage();
                    }
                }
                throw new MessageParseException("unknown type: " + type);
            }
        }
        throw new InternalError();
    }
}

