/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.io.AbstractIoFilterChain;
import org.apache.mina.io.IoFilter;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.IoSessionFilterChain;
import org.apache.mina.io.IoSessionManager;

public abstract class IoSessionManagerFilterChain
extends AbstractIoFilterChain {
    private final IoSessionManager manager;

    protected IoSessionManagerFilterChain(IoSessionManager manager) {
        this.manager = manager;
    }

    public IoSessionManager getManager() {
        return this.manager;
    }

    protected IoFilter createTailFilter() {
        return new IoFilter(){

            public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
                ((IoSessionFilterChain)session.getFilterChain()).sessionOpened(session);
            }

            public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
                ((IoSessionFilterChain)session.getFilterChain()).sessionClosed(session);
            }

            public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
                ((IoSessionFilterChain)session.getFilterChain()).sessionIdle(session, status);
            }

            public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
                ((IoSessionFilterChain)session.getFilterChain()).exceptionCaught(session, cause);
            }

            public void dataRead(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf) throws Exception {
                ((IoSessionFilterChain)session.getFilterChain()).dataRead(session, buf);
            }

            public void dataWritten(IoFilter.NextFilter nextFilter, IoSession session, Object marker) throws Exception {
                ((IoSessionFilterChain)session.getFilterChain()).dataWritten(session, marker);
            }

            public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf, Object marker) throws Exception {
                nextFilter.filterWrite(session, buf, marker);
            }
        };
    }
}

