/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.base;

import org.drools.rule.Rule;
import org.drools.semantics.base.ClassFieldObjectType;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.smf.ObjectTypeFactory;
import org.drools.spi.Importer;
import org.drools.spi.ObjectType;
import org.drools.spi.RuleBaseContext;

public class ClassFieldObjectTypeFactory
implements ObjectTypeFactory {
    private static final ClassFieldObjectTypeFactory INSTANCE = new ClassFieldObjectTypeFactory();

    public static ClassFieldObjectTypeFactory getInstance() {
        return INSTANCE;
    }

    public ObjectType newObjectType(Rule rule, RuleBaseContext context, Configuration config) throws FactoryException {
        String className = config.getText();
        String fieldName = config.getAttribute("field");
        String fieldValue = config.getAttribute("value");
        if (className == null || className.trim().equals("")) {
            throw new FactoryException("no class name specified");
        }
        if (fieldName == null || fieldName.trim().equals("")) {
            throw new FactoryException("no field name specified");
        }
        if (fieldValue == null || fieldValue.trim().equals("")) {
            throw new FactoryException("no field value specified");
        }
        Class clazz = null;
        try {
            ClassLoader cl = (ClassLoader)context.get((Object)"smf-classLoader");
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
                context.put((Object)"smf-classLoader", (Object)cl);
            }
            if (cl == null) {
                cl = this.getClass().getClassLoader();
                context.put((Object)"smf-classLoader", (Object)cl);
            }
            Importer importer = rule.getImporter();
            clazz = importer.importClass(cl, className);
            clazz.getMethod("get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null);
        }
        catch (SecurityException e) {
            throw new FactoryException("Field '" + fieldName + "' is not accessible for Class '" + className + "'");
        }
        catch (NoSuchMethodException e) {
            throw new FactoryException("Field '" + fieldName + "' does not exist for Class '" + className + "'");
        }
        catch (ClassNotFoundException e) {
            throw new FactoryException(e.getMessage());
        }
        catch (Error e) {
            throw new FactoryException(e.getMessage());
        }
        return new ClassFieldObjectType(clazz, fieldName, fieldValue);
    }
}

