/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.reteoo.ConditionNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.JoinNodeInput;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ParameterNode;
import org.drools.reteoo.ReflectiveVisitor;
import org.drools.reteoo.Rete;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSource;
import org.drools.rule.Declaration;

public class ReteooDotDumpVisitor
extends ReflectiveVisitor {
    private static final String NULL_STRING = "<NULL>";
    private static final String INDENT = "    ";
    private final PrintStream out;
    private Set visitedNodes = new HashSet();
    private int nullDotId;

    public ReteooDotDumpVisitor(PrintStream outPrintStream) {
        this.out = outPrintStream;
    }

    public void visitObject(Object object) {
        this.makeNode(object, "Unknown Object", "object: " + object + newline + "class: " + object.getClass());
    }

    public void visitNull() {
        this.makeNode("NULL" + this.nullDotId++, NULL_STRING);
    }

    public void visitRuleBaseImpl(RuleBaseImpl ruleBase) {
        this.visit(ruleBase.getRete());
    }

    public void visitRete(Rete rete) {
        this.makeNode(rete, "RETE-OO");
        Iterator i = rete.getObjectTypeNodeIterator();
        while (i.hasNext()) {
            Object nextNode = i.next();
            this.makeEdge(rete, nextNode);
            this.visitNode(nextNode);
        }
    }

    public void visitObjectTypeNode(ObjectTypeNode node) {
        this.makeNode(node, "ObjectTypeNode", "objectType: " + node.getObjectType());
        Iterator i = node.getParameterNodeIterator();
        while (i.hasNext()) {
            Object nextNode = i.next();
            this.makeEdge(node, nextNode);
            this.visitNode(nextNode);
        }
    }

    public void visitParameterNode(ParameterNode node) {
        this.makeTupleSourceNode(node, "ParameterNode", "TupleSource", "decl: " + ReteooDotDumpVisitor.format(node.getDeclaration()));
    }

    private void makeTupleSourceNode(TupleSource node, String nodeType, String tupleType, String label) {
        this.makeNode(node, nodeType, tupleType, label);
        Iterator i = node.getTupleSinks().iterator();
        while (i.hasNext()) {
            Object nextNode = i.next();
            this.makeEdge(node, nextNode);
            this.visitNode(nextNode);
        }
    }

    public void visitConditionNode(ConditionNode node) {
        this.makeTupleSourceNode(node, "ConditionNode", "TupleSource/TupleSink", "condition: " + node.getCondition() + newline + this.format(node.getTupleDeclarations(), "tuple"));
    }

    public void visitJoinNodeInput(JoinNodeInput node) {
        this.makeNode(node, "JoinNodeInput", "TupleSink", node.getSide() == 41 ? "LEFT" : "RIGHT");
        JoinNode nextNode = node.getJoinNode();
        this.makeEdge(node, nextNode);
        this.visitNode(nextNode);
    }

    public void visitJoinNode(JoinNode node) {
        this.makeTupleSourceNode(node, "JoinNode", "TupleSource", this.format(node.getCommonDeclarations(), "common") + newline + this.format(node.getTupleDeclarations(), "tuple"));
    }

    public void visitTerminalNode(TerminalNode node) {
        this.makeNode(node, "TerminalNode", "TupleSink", "rule: " + node.getRule().getName());
    }

    private void visitNode(Object node) {
        if (!this.visitedNodes.contains(ReteooDotDumpVisitor.dotId(node))) {
            this.visitedNodes.add(ReteooDotDumpVisitor.dotId(node));
            this.visit(node);
        }
    }

    private void makeNode(Object object, String type, String label) {
        this.makeNode(object, type, null, label);
    }

    private void makeNode(Object object, String nodeType, String tupleType, String label) {
        this.makeNode(object, nodeType + "@" + ReteooDotDumpVisitor.dotId(object) + newline + (null == tupleType ? "" : "(" + tupleType + ")" + newline) + label);
    }

    private void makeNode(Object object, String label) {
        this.out.println("    \"" + ReteooDotDumpVisitor.dotId(object) + "\" " + "[" + this.getStyle(object) + ", label=\"" + ReteooDotDumpVisitor.format(label) + "\"];");
    }

    private void makeEdge(Object fromNode, Object toNode) {
        this.out.println("    \"" + ReteooDotDumpVisitor.dotId(fromNode) + "\" -> \"" + ReteooDotDumpVisitor.dotId(toNode) + "\";");
    }

    private static String dotId(Object object) {
        return Integer.toHexString(System.identityHashCode(object)).toUpperCase();
    }

    private String format(Set declarationSet, String declString) {
        int i;
        if (declarationSet.isEmpty()) {
            return "No " + declString + " declarations";
        }
        Declaration[] declarations = declarationSet.toArray(new Declaration[0]);
        StringBuffer label = new StringBuffer();
        int max = declarations.length - 1;
        for (i = 0; i < max; ++i) {
            label.append(declString + "Decl: " + ReteooDotDumpVisitor.format(declarations[i]) + newline);
        }
        label.append(declString + "Decl: " + ReteooDotDumpVisitor.format(declarations[i]));
        return label.toString();
    }

    private static String format(Declaration declaration) {
        return null == declaration ? NULL_STRING : declaration.getIdentifier() + " (" + declaration.getObjectType() + ")";
    }

    private static String format(String label) {
        if (null == label) {
            return NULL_STRING;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(label.getBytes())));
        StringBuffer buffer = new StringBuffer();
        try {
            boolean firstLine = true;
            String line = br.readLine();
            while (null != line) {
                if (line.trim().length() != 0) {
                    if (firstLine) {
                        firstLine = false;
                    } else {
                        buffer.append("\\n");
                    }
                    if (-1 == line.indexOf(34)) {
                        buffer.append(line);
                    } else {
                        int max = line.length();
                        for (int i = 0; i < max; ++i) {
                            char c = line.charAt(i);
                            if ('\"' == c) {
                                buffer.append(92 + c);
                                continue;
                            }
                            buffer.append(c);
                        }
                    }
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error formatting '" + label + "': " + e.getMessage());
        }
        return buffer.toString();
    }

    private String getStyle(Object node) {
        String style = node instanceof Rete ? "style=\"filled\", shape=\"ellipse\"" : (node instanceof ObjectTypeNode ? "style=\"filled\", fillcolor=\"cyan4\", shape=\"rectangle\"" : (node instanceof ParameterNode ? "style=\"filled\", fillcolor=\"cyan3\", shape=\"rectangle\"" : (node instanceof ConditionNode ? "style=\"filled\", fillcolor=\"yellow3\", shape=\"diamond\"" : (node instanceof JoinNodeInput ? "style=\"filled\", fillcolor=\"chartreuse\", shape=\"invtriangle\"" : (node instanceof JoinNode ? "style=\"filled\", fillcolor=\"green\", shape=\"house\"" : (node instanceof TerminalNode ? "style=\"filled\", shape=\"ellipse\"" : "style=\"filled\", fillcolor=\"yellow3\", shape=\"ellipse\""))))));
        return style;
    }
}

