/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.drools.reteoo.AgendaItem;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.AsyncExceptionHandler;
import org.drools.spi.ConsequenceException;

final class Scheduler {
    private static final Scheduler INSTANCE = new Scheduler();
    private final Timer scheduler = new Timer(true);
    private final Map tasks = new HashMap();
    private AsyncExceptionHandler exceptionHandler;

    static Scheduler getInstance() {
        return INSTANCE;
    }

    private Scheduler() {
    }

    void scheduleAgendaItem(AgendaItem item, WorkingMemoryImpl workingMemory) {
        Date now = new Date();
        Date then = new Date(now.getTime() + item.getRule().getDuration().getDuration(item.getTuple()) * 1000L);
        AgendaItemFireListener task = new AgendaItemFireListener(item, workingMemory);
        this.scheduler.schedule((TimerTask)task, then);
        this.tasks.put(item, task);
    }

    void cancelAgendaItem(AgendaItem item) {
        TimerTask task = (TimerTask)this.tasks.remove(item);
        if (task != null) {
            task.cancel();
        }
    }

    void setAsyncExceptionHandler(AsyncExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    AsyncExceptionHandler getAsyncExceptionHandler() {
        return this.exceptionHandler;
    }

    public int size() {
        return this.tasks.size();
    }

    class AgendaItemFireListener
    extends TimerTask {
        private AgendaItem item;
        private WorkingMemoryImpl workingMemory;

        AgendaItemFireListener(AgendaItem item, WorkingMemoryImpl workingMemory) {
            this.item = item;
            this.workingMemory = workingMemory;
        }

        public void run() {
            try {
                this.item.fire(this.workingMemory);
                Scheduler.this.tasks.remove(this.item);
            }
            catch (ConsequenceException e) {
                Scheduler.getInstance().getAsyncExceptionHandler().handleException(this.workingMemory, e);
            }
        }
    }
}

