/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import thredds.filesystem.CacheFileProto;
import thredds.filesystem.FileSystemProto;

public class CacheDirectoryProto
implements Externalizable {
    private static final long serialVersionUID = 7526472295622776147L;
    protected String path;
    protected long lastModified;
    private CacheFileProto[] children;
    private HashMap<String, Object> att;

    public String getPath() {
        return this.path;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public CacheDirectoryProto() {
    }

    public CacheDirectoryProto(File dir) {
        this.path = dir.getPath();
        this.lastModified = dir.lastModified();
        File[] subs = dir.listFiles();
        if (subs == null) {
            subs = new File[]{};
        }
        this.children = new CacheFileProto[subs.length];
        int count = 0;
        for (File f : subs) {
            this.children[count++] = new CacheFileProto(f);
        }
    }

    public boolean notModified() {
        File f = new File(this.getPath());
        return f.lastModified() <= this.lastModified;
    }

    public CacheFileProto[] getChildren() {
        return this.children;
    }

    public String toString() {
        return "CacheDirectoryProto {path='" + this.path + '\'' + ", num children=" + (this.children == null ? 0 : this.children.length) + '}';
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FileSystemProto.Directory.Builder dirBuilder = FileSystemProto.Directory.newBuilder();
        dirBuilder.setPath(this.getPath());
        dirBuilder.setLastModified(this.getLastModified());
        FileSystemProto.File.Builder fileBuilder = FileSystemProto.File.newBuilder();
        for (CacheFileProto child : this.children) {
            fileBuilder.clear();
            fileBuilder.setName(child.getShortName());
            fileBuilder.setIsDirectory(child.isDirectory());
            fileBuilder.setLastModified(child.getLastModified());
            fileBuilder.setLength(child.getLength());
            dirBuilder.addFiles(fileBuilder);
        }
        FileSystemProto.Directory dirProto = dirBuilder.build();
        byte[] b = dirProto.toByteArray();
        out.writeInt(b.length);
        out.write(b);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int got;
        int len = in.readInt();
        byte[] b = new byte[len];
        for (int done = 0; done < len; done += got) {
            got = in.read(b, done, len - done);
            if (got >= 0) continue;
            throw new IOException();
        }
        FileSystemProto.Directory proto = FileSystemProto.Directory.parseFrom(b);
        this.path = proto.getPath();
        this.lastModified = proto.getLastModified();
        List<FileSystemProto.File> files = proto.getFilesList();
        this.children = new CacheFileProto[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            FileSystemProto.File fp = files.get(i);
            CacheFileProto cf = new CacheFileProto();
            cf.setShortName(fp.getName());
            cf.setDirectory(fp.getIsDirectory());
            cf.setLastModified(fp.getLastModified());
            cf.setLength(fp.getLength());
            this.children[i] = cf;
        }
    }
}

