/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;

public class SequenceIterator
implements StructureDataIterator {
    private int start;
    private int size;
    private int count;
    private ArrayStructure abb;

    public SequenceIterator(int start, int size, ArrayStructure abb) {
        this.start = start;
        this.size = size;
        this.abb = abb;
        this.count = 0;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.count < this.size;
    }

    @Override
    public StructureData next() throws IOException {
        StructureData result = this.abb.getStructureData(this.start + this.count);
        ++this.count;
        return result;
    }

    @Override
    public void setBufferSize(int bytes) {
    }

    @Override
    public StructureDataIterator reset() {
        this.count = 0;
        return this;
    }

    @Override
    public int getCurrentRecno() {
        return this.count;
    }
}

