/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.Errors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopyCat {
    private boolean classMissing = false;

    public void copy() throws FileNotFoundException, SecurityException {
        try {
            File rootPath = this.getInputDir(System.getProperty("install.root"));
            File gjPath = this.getInputDir(rootPath, "gj");
            File outPath = this.getOutputDir("gj");
            File utilPath = this.getInputDir(gjPath, "util");
            File outUtilPath = this.getOutputDir(outPath, "util");
            this.copy("Dictionary.class", utilPath, outUtilPath);
            this.copy("Enumeration.class", utilPath, outUtilPath);
            this.copy("Hashtable.class", utilPath, outUtilPath);
            this.copy("HashtableEntry.class", utilPath, outUtilPath);
            this.copy("KeyEnumerator.class", utilPath, outUtilPath);
            this.copy("Stack.class", utilPath, outUtilPath);
            this.copy("ValueEnumerator.class", utilPath, outUtilPath);
            this.copy("Vector.class", utilPath, outUtilPath);
            this.copy("VectorEnumerator.class", utilPath, outUtilPath);
            File langPath = this.getInputDir(gjPath, "lang");
            File outLangPath = this.getOutputDir(outPath, "lang");
            File reflectPath = this.getInputDir(langPath, "reflect");
            File outReflectPath = this.getOutputDir(outLangPath, "reflect");
            this.copy("Array.class", reflectPath, outReflectPath);
        }
        catch (NullPointerException e) {
            Errors.softErr("\"install.root\" property is not set to indicate the root directory of JTB.");
            throw new FileNotFoundException();
        }
        if (this.classMissing) {
            throw new FileNotFoundException();
        }
    }

    public void copy(String className, File sourcePath, File destinationPath) {
        try {
            FileInputStream in = new FileInputStream(new File(sourcePath, className));
            FileOutputStream out = new FileOutputStream(new File(destinationPath, className));
            int i = ((InputStream)in).read();
            while (i >= 0) {
                ((OutputStream)out).write(i);
                i = ((InputStream)in).read();
            }
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
        catch (IOException e) {
            this.classMissing = true;
            Errors.softErr(className + " not found in directory " + sourcePath.getPath());
        }
    }

    public File getInputDir(String name) throws FileNotFoundException {
        File ret = new File(name);
        if (!ret.exists()) {
            Errors.softErr(name + " is not the root directory of JTB.");
            throw new FileNotFoundException();
        }
        return ret;
    }

    public File getInputDir(File parent, String name) throws FileNotFoundException {
        File ret = new File(parent, name);
        if (!ret.exists()) {
            Errors.softErr(name + " subdirectory not found in " + parent.getPath() + " of JTB.");
            throw new FileNotFoundException();
        }
        return ret;
    }

    public File getOutputDir(String name) throws FileNotFoundException {
        File ret = new File(name);
        if (!ret.exists()) {
            ret.mkdir();
        } else if (!ret.isDirectory()) {
            Errors.softErr(name + " exists but is not a directory.");
            throw new FileNotFoundException();
        }
        return ret;
    }

    public File getOutputDir(File parent, String name) throws FileNotFoundException {
        File ret = new File(parent, name);
        if (!ret.exists()) {
            ret.mkdir();
        } else if (!ret.isDirectory()) {
            Errors.softErr(name + " exists but is not a subdirectory in " + parent.getPath() + ".");
            throw new FileNotFoundException();
        }
        return ret;
    }
}

