/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.showcase;

import com.google.gwt.core.client.GWT;

import eu.maydu.gwt.validation.client.i18n.ValidationMessages;
import eu.maydu.gwt.validation.client.i18n.utils.MessageInterpolator;

public class ShowcaseValidationMessages extends ValidationMessages {

	private ShowcaseValidationConstants msg = GWT.create(ShowcaseValidationConstants.class);
	
	
	public String getPropertyName(String propertyName) {
		if(propertyName.equals("positiveInteger"))
			return msg.positiveInteger();
		else if(propertyName.equals("integerInRangeMinus5000Plus5000"))
			return msg.integerInRangeMinus5000Plus5000();
		else if(propertyName.equals("anyInteger"))
			return msg.anyInteger();
		else if(propertyName.equals("stringLengthSmaller5"))
			return msg.stringLengthSmaller5();
		else if(propertyName.equals("stringLengthBetween2And5"))
			return msg.stringLengthBetween2And5();
		else if(propertyName.equals("notEmpty"))
			return msg.notEmpty();
		else if(propertyName.equals("enterRegExedText"))
			return msg.enterRegExedText();
		
		return "unknown property name";
	}
	
	public ShowcaseValidationConstants getPropertyNameConstants() {
		return msg;
	}
	
	public String getDescriptionMessage(String key) {
		//if(key.equals("test"))
			//return "Some html description text<br/><font style=\"color:#f00;\">Cool!</font>";
		
		if(key.equals("positiveIntegerHelp"))
			return msg.positiveIntegerHelp();
		else if(key.equals("integerInRangeMinus5000Plus5000Help"))
			return msg.integerInRangeMinus5000Plus5000Help();
		else if(key.equals("anyIntegerHelp"))
			return msg.anyIntegerHelp();
		else if(key.equals("stringLengthSmaller5Help"))
			return msg.stringLengthSmaller5Help();
		else if(key.equals("stringLengthBetween2And5Help"))
			return msg.stringLengthBetween2And5Help();
		else if(key.equals("notEmptyHelp"))
			return msg.notEmptyHelp();
		else if(key.equals("password.description"))
			return msg.passwordHelp();
		else if(key.equals("multiEquals.description"))
			return msg.multiEqualsHelp();
		else if(key.equals("regexText.description"))
			return msg.regexTextDescription();
		
		return "Unknown key: "+key; 
	}
	
	@Override
	public String getCustomMessage(String key, Object... parameters) {

		
		
		if(key.equals("regexNotMatched"))
			return MessageInterpolator.merge(msg.regexNotMatched(), parameters);
		
		return null;
		
		//return "localization not found for key: "+key;
	}
}
