/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.showcase.panels;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

import eu.maydu.gwt.validation.client.DefaultValidationProcessor;
import eu.maydu.gwt.validation.client.ValidationProcessor;
import eu.maydu.gwt.validation.client.actions.StyleAction;
import eu.maydu.gwt.validation.client.showcase.ShowcaseValidationConstants;
import eu.maydu.gwt.validation.client.validators.numeric.IntegerValidator;


public class TestPanel {
	
	
	private ValidationProcessor validator = new DefaultValidationProcessor();

	
	private TextBox text1 = new TextBox();
	
	
	private ShowcaseValidationConstants constants = GWT.create(ShowcaseValidationConstants.class);
	
	public Panel getPanel() {
		
		text1.removeStyleName("gwt-TextBox");
		//text1.addStyleName("validationFailedBorder");
		
		GWT.log("Stylename: "+text1.getStyleName(), null);
		GWT.log("Primary style: "+text1.getStylePrimaryName(), null);
		
		
		HorizontalPanel panel = new HorizontalPanel();
		panel.add(text1);
		
		Button validateButton = new Button("Validate");
		panel.add(validateButton);
		
		validateButton.addClickListener(new ClickListener() {

			public void onClick(Widget sender) {
				validator.validate();
				GWT.log("Styles after validating", null);
				GWT.log("Stylename: "+text1.getStyleName(), null);
				GWT.log("Primary style: "+text1.getStylePrimaryName(), null);
			}
		});
		
		
		Button resetButton = new Button("Reset");
		panel.add(resetButton);
		resetButton.addClickListener(new ClickListener() {

			public void onClick(Widget sender) {
				validator.reset();
				GWT.log("Styles after reseting", null);
				GWT.log("Stylename: "+text1.getStyleName(), null);
				GWT.log("Primary style: "+text1.getStylePrimaryName(), null);
			}
			
		});
		
		validator.addValidators("int", new IntegerValidator(text1, 0, 50000).addActionForFailure(new StyleAction("validationFailedBorder")));
		
		return panel;
	}

}
