/*
 * Decompiled with CFR 0.152.
 */
package eu.rekawek.toxiproxy;

import com.google.gson.JsonObject;
import eu.rekawek.toxiproxy.HttpClient;
import eu.rekawek.toxiproxy.model.ToxicList;
import java.io.IOException;

public class Proxy {
    private final HttpClient httpClient;
    private final String path;
    private String name;
    private String listen;
    private String upstream;
    private boolean enabled;
    private ToxicList toxicList;

    public Proxy(HttpClient httpClient, String path, JsonObject json) {
        this.httpClient = httpClient;
        this.path = path;
        this.setFromJson(json);
    }

    private void setFromJson(JsonObject json) {
        this.name = json.get("name").getAsString();
        this.listen = json.get("listen").getAsString();
        this.upstream = json.get("upstream").getAsString();
        this.enabled = json.get("enabled").getAsBoolean();
        this.toxicList = new ToxicList(this.httpClient, this.path + "/toxics");
    }

    public String getName() {
        return this.name;
    }

    public String getListen() {
        return this.listen;
    }

    public String getUpstream() {
        return this.upstream;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ToxicList toxics() {
        return this.toxicList;
    }

    public void setListen(String listen) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "listen", listen));
    }

    public void setUpstream(String upstream) throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "upstream", upstream));
    }

    public void enable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", true));
    }

    public void disable() throws IOException {
        this.setFromJson(this.httpClient.post(this.path, "enabled", false));
    }

    public void delete() throws IOException {
        this.httpClient.delete(this.path);
    }

    void reset() throws IOException {
        this.setFromJson(this.httpClient.get(this.path));
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": name=" + this.getName() + ", enabled=" + this.isEnabled();
    }
}

