/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes;

import eu.stamp_project.descartes.DescartesMutationEngine;
import eu.stamp_project.descartes.codemanipulation.MethodInfo;
import eu.stamp_project.descartes.operators.MutationOperator;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.functional.predicate.Or;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.EngineArguments;
import org.pitest.mutationtest.MutationEngineFactory;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.util.Glob;

public class DescartesEngineFactory
implements MutationEngineFactory {
    public MutationEngine createEngine(EngineArguments engineArguments) {
        Collection<String> operators = engineArguments.mutators();
        if (operators == null || operators.isEmpty()) {
            operators = DescartesEngineFactory.getDefaultOperators();
        }
        return this.createEngine(DescartesEngineFactory.globsToPredicate(engineArguments.excludedMethods()), operators.stream().map(MutationOperator::fromID).collect(Collectors.toList()));
    }

    public MutationEngine createEngine(Predicate<MethodInfo> excludedMethods, Collection<MutationOperator> operators) {
        return new DescartesMutationEngine(excludedMethods, operators);
    }

    public static Collection<String> getDefaultOperators() {
        return Arrays.asList("void", "null", "empty", "true", "false", "0", "1", "(short)0", "(short)1", "(byte)0", "(byte)1", "0L", "1L", "0.0", "1.0", "0.0f", "1.0f", "'\\40'", "'A'", "\"\"", "\"A\"");
    }

    public static Predicate<MethodInfo> globsToPredicate(Collection<String> globs) {
        Or excludedNames = Prelude.or((Iterable)Glob.toGlobPredicates(globs));
        return arg_0 -> DescartesEngineFactory.lambda$globsToPredicate$0((Predicate)excludedNames, arg_0);
    }

    public String name() {
        return "descartes";
    }

    public String description() {
        return "Extreme mutation engine";
    }

    private static /* synthetic */ boolean lambda$globsToPredicate$0(Predicate excludedNames, MethodInfo method) {
        return excludedNames.test(method.getName());
    }
}

