/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes;

import eu.stamp_project.descartes.codemanipulation.MethodInfo;
import eu.stamp_project.descartes.codemanipulation.MutationClassAdapter;
import eu.stamp_project.descartes.codemanipulation.MutationPointFinder;
import eu.stamp_project.descartes.operators.MutationOperator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Mutant;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.ClassWriter;

public class DescartesMutater
implements Mutater {
    private final ClassByteArraySource byteSource;
    private final Predicate<MethodInfo> excludedMethods;
    private final Collection<MutationOperator> operators;

    public DescartesMutater(ClassByteArraySource byteSource, Predicate<MethodInfo> excludedMethods, Collection<MutationOperator> operators) {
        Objects.requireNonNull(byteSource, "Source to inspect for mutations can not be null");
        this.byteSource = byteSource;
        Objects.requireNonNull(excludedMethods, "Predicate for excluded methods can not be null");
        this.excludedMethods = excludedMethods;
        Objects.requireNonNull(operators, "Collection of mutation operators can not be null");
        this.operators = operators;
    }

    public List<MutationDetails> findMutations(ClassName classToMutate) {
        Optional classBytes = this.byteSource.getBytes(classToMutate.asInternalName());
        if (!classBytes.isPresent()) {
            return Collections.emptyList();
        }
        MutationPointFinder finder = new MutationPointFinder(this.excludedMethods, this.operators);
        ClassReader reader = new ClassReader((byte[])classBytes.get());
        return finder.findMutationPoints(classToMutate, reader);
    }

    private byte[] createMutant(MutationIdentifier mID) {
        Optional bytes = this.byteSource.getBytes(mID.getClassName().asJavaName());
        ClassReader reader = new ClassReader((byte[])bytes.orElseThrow(() -> new IllegalArgumentException("Class " + mID.getClassName().asJavaName() + " not found in the binary source")));
        ClassWriter writer = new ClassWriter(3);
        MutationClassAdapter adapter = new MutationClassAdapter(mID, (ClassVisitor)writer);
        reader.accept((ClassVisitor)adapter, 0);
        return writer.toByteArray();
    }

    public Mutant getMutation(MutationIdentifier mID) {
        return new Mutant(new MutationDetails(mID, "", "", 0, 0), this.createMutant(mID));
    }
}

