/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.codemanipulation;

import eu.stamp_project.descartes.codemanipulation.ElementInfo;
import eu.stamp_project.descartes.codemanipulation.TypeInfo;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.reloc.asm.Type;

public class MethodInfo
extends ElementInfo {
    private final Type returnType;
    private final List<Type> argumentTypes;
    private final Set<Type> exceptions;
    private final TypeInfo owner;
    private final String descriptor;

    public MethodInfo(Method method) {
        super(method.getModifiers(), method.getName(), method.toGenericString());
        Type methodType = Type.getType((Method)method);
        this.owner = new TypeInfo(method.getDeclaringClass());
        this.descriptor = methodType.getDescriptor();
        this.returnType = methodType.getReturnType();
        this.argumentTypes = List.of(methodType.getArgumentTypes());
        this.exceptions = Stream.of(method.getExceptionTypes()).map(Type::getType).collect(Collectors.toSet());
    }

    public MethodInfo(TypeInfo owner, int access, String name, String desc, String signature, String[] exceptions) {
        super(access, name, signature);
        this.owner = owner;
        this.descriptor = desc;
        this.returnType = Type.getReturnType((String)desc);
        this.argumentTypes = List.of(Type.getArgumentTypes((String)desc));
        this.exceptions = this.toTypeSet(exceptions);
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public Set<Type> getExceptions() {
        return this.exceptions;
    }

    public TypeInfo getOwner() {
        return this.owner;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }

    public boolean hasNoCode() {
        return this.hasFlag(1280);
    }
}

