/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.interceptors;

import eu.stamp_project.descartes.interceptors.MutationFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.objectweb.asm.tree.AnnotationNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.reloc.asm.Type;

public class SkipDoNotMutateFilter
extends MutationFilter {
    @Override
    public boolean allows(MutationDetails details) {
        Optional<MethodTree> method = this.getMethod(details);
        return method.isPresent() && this.mayMutate(method.get(), this.getCurrentClass(), details.getMutator());
    }

    private boolean mayMutate(MethodTree method, ClassTree owner, String mutator) {
        Optional<AnnotationNode> doNotMutateAnnotation = this.getDoNotMutateAnnotation(method.annotations());
        if (doNotMutateAnnotation.isPresent()) {
            return this.isMutationAllowed(doNotMutateAnnotation.get(), mutator);
        }
        doNotMutateAnnotation = this.getDoNotMutateAnnotation(owner.annotations());
        return !doNotMutateAnnotation.isPresent() || this.isMutationAllowed(doNotMutateAnnotation.get(), mutator);
    }

    private Optional<AnnotationNode> getDoNotMutateAnnotation(List<AnnotationNode> annotations) {
        return annotations.stream().filter(annotation -> Type.getType((String)annotation.desc).getClassName().endsWith(".DoNotMutate")).findFirst();
    }

    private boolean isMutationAllowed(AnnotationNode annotation, String mutator) {
        Set<String> explicitlyForbiddenMutators = this.forbiddenMutators(annotation);
        return !explicitlyForbiddenMutators.isEmpty() && !explicitlyForbiddenMutators.contains(mutator);
    }

    private Set<String> forbiddenMutators(AnnotationNode annotation) {
        List values = annotation.values;
        if (values == null || values.size() < 2) {
            return Collections.emptySet();
        }
        Object parameter = values.get(1);
        if (parameter instanceof String) {
            return Set.of((String)parameter);
        }
        if (parameter instanceof List) {
            HashSet<String> result = new HashSet<String>();
            for (Object val : (List)parameter) {
                if (!(val instanceof String)) continue;
                result.add((String)val);
            }
            return result;
        }
        return Collections.emptySet();
    }
}

