/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.interceptors.stopmethods;

import eu.stamp_project.descartes.interceptors.stopmethods.StopMethodInterceptor;
import eu.stamp_project.descartes.interceptors.stopmethods.StopMethodMatcher;
import eu.stamp_project.descartes.interceptors.stopmethods.StopMethodMatchers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParameter;

public class StopMethodMatcherInterceptorFactory
implements MutationInterceptorFactory {
    private FeatureParameter EXCEPT;
    private Map<String, StopMethodMatcher> availableMatchers = new HashMap<String, StopMethodMatcher>();

    public StopMethodMatcherInterceptorFactory() {
        this.availableMatchers.put("empty", StopMethodMatchers.isEmptyVoid());
        this.availableMatchers.put("enum", StopMethodMatchers.isEnumGenerated());
        this.availableMatchers.put("to_string", StopMethodMatchers.isToString());
        this.availableMatchers.put("hash_code", StopMethodMatchers.isHashCode());
        this.availableMatchers.put("deprecated", StopMethodMatchers.isDeprecated());
        this.availableMatchers.put("synthetic", StopMethodMatchers.isSynthetic());
        this.availableMatchers.put("getter", StopMethodMatchers.isSimpleGetter());
        this.availableMatchers.put("setter", StopMethodMatchers.isSimpleSetter());
        this.availableMatchers.put("constant", StopMethodMatchers.returnsAConstant());
        this.availableMatchers.put("delegate", StopMethodMatchers.isDelegate());
        this.availableMatchers.put("clinit", StopMethodMatchers.isStaticInitializer());
        this.availableMatchers.put("empty_array", StopMethodMatchers.returnsAnEmptyArray());
        this.availableMatchers.put("null_return", StopMethodMatchers.returnsNull());
        this.availableMatchers.put("return_this", StopMethodMatchers.returnsThis());
        this.availableMatchers.put("return_param", StopMethodMatchers.returnsAParameter());
        this.availableMatchers.put("kotlin_setter", StopMethodMatchers.isKotlinGeneratedSetter());
        Object description = "Allows to reinsert some stop methods into the analysis. Possible values are: ";
        description = (String)description + String.join((CharSequence)", ", this.availableMatchers.keySet());
        this.EXCEPT = FeatureParameter.named((String)"except").withDescription((String)description);
    }

    public MutationInterceptor createInterceptor(InterceptorParameters interceptorParameters) {
        Set<String> matchers = this.availableMatchers.keySet();
        List exclusions = interceptorParameters.getList(this.EXCEPT);
        if (exclusions != null) {
            matchers.removeAll(exclusions);
        }
        return new StopMethodInterceptor(StopMethodMatcher.any(matchers.stream().map(key -> this.availableMatchers.get(key)).collect(Collectors.toList())));
    }

    public Feature provides() {
        return Feature.named((String)"STOP_METHODS").withOnByDefault(true).withDescription("Filters out mutations in methods that are generally of no interest").withParameter(this.EXCEPT);
    }

    public String description() {
        return "Stop methods filter";
    }
}

