/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.descartes.reporting;

import eu.stamp_project.descartes.reporting.JSONWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;

public class JSONReportListener
implements MutationResultListener {
    private ResultOutputStrategy strategy;
    private Collection<String> mutators;
    private long startTime;
    private JSONWriter report;

    public JSONReportListener(long startTime, Collection<String> mutators, ResultOutputStrategy strategy) {
        this.strategy = strategy;
        this.startTime = startTime;
        this.mutators = mutators;
    }

    public void runStart() {
        try {
            this.report = new JSONWriter(this.strategy.createWriterForFile("mutations.json"));
            this.report.beginObject();
            this.report.beginListAttribute("mutators");
            for (String mutator : this.mutators) {
                this.report.write(mutator);
            }
            this.report.endList();
            this.report.beginListAttribute("mutations");
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }

    public void handleMutationResult(ClassMutationResults classMutationResults) {
        try {
            for (MutationResult result : classMutationResults.getMutations()) {
                MutationDetails details = result.getDetails();
                DetectionStatus status = result.getStatus();
                MutationStatusTestPair pair = result.getStatusTestPair();
                String method = details.getMethod();
                String methodDescription = details.getId().getLocation().getMethodDesc();
                this.report.beginObject();
                this.report.writeAttribute("detected", status.isDetected());
                this.report.writeAttribute("status", status.name());
                this.report.writeAttribute("mutator", details.getMutator());
                this.report.writeAttribute("line", details.getLineNumber());
                this.report.writeAttribute("block", details.getBlock());
                this.report.writeAttribute("file", details.getFilename());
                this.report.writeAttribute("index", details.getFirstIndex());
                this.report.beginObjectAttribute("method");
                this.report.writeAttribute("name", method);
                this.report.writeAttribute("description", methodDescription);
                this.report.writeAttribute("class", details.getClassName().getNameWithoutPackage().asJavaName());
                this.report.writeAttribute("package", details.getClassName().getPackage().asJavaName());
                this.report.endObject();
                this.report.beginObjectAttribute("tests");
                this.report.writeAttribute("run", result.getNumberOfTestsRun());
                this.report.writeStringListAttribute("ordered", details.getTestsInOrder().stream().map(TestInfo::getName).collect(Collectors.toList()));
                this.report.writeStringListAttribute("killing", pair.getKillingTests());
                this.report.writeStringListAttribute("succeeding", pair.getSucceedingTests());
                this.report.endObject();
                this.report.endObject();
            }
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }

    public void runEnd() {
        try {
            this.report.endList();
            this.report.writeAttribute("time", System.currentTimeMillis() - this.startTime);
            this.report.endObject();
            this.report.close();
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }
}

