/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.signerclient;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.exoplatform.applet.Invokable;
import org.exoplatform.applet.logging.Logger;
import org.exoplatform.applet.logging.file.FileLoggerFactory;
import org.exoplatform.applet.plugin.AppletPlugin;
import org.exoplatform.applet.plugin.Pluggable;
import org.exoplatform.applet.scripting.ScriptableBrowserSupport;
import org.exoplatform.applet.scripting.ScriptingBrowser;
import org.exoplatform.applet.scripting.ScriptingObject;
import org.exoplatform.applications.signerclient.ExoSignerException;
import org.exoplatform.applications.signerclient.SignStatus;
import org.exoplatform.applications.signerclient.SignatureInfo;
import org.exoplatform.applications.signerclient.SignerParameters;
import org.exoplatform.applications.signerclient.crypto.CryptoException;
import org.exoplatform.applications.signerclient.crypto.CryptoPlugin;
import org.exoplatform.applications.signerclient.util.SignerUtil;

public class ExoSignerApplet
extends JApplet
implements Pluggable,
Invokable,
ScriptableBrowserSupport {
    private static final long serialVersionUID = 1L;
    private static final String LOG_SOURCE_CLASS = "ExoSignerApplet";
    private static final String DEFAULT_ALGORITHM = "SHA1withRSA";
    private static final String DEFAULT_CERTIFICATE_TYPE = "X.509";
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String TRUE = Boolean.TRUE.toString();
    private Logger logger = FileLoggerFactory.getInstance().getLogger(ExoSignerApplet.class.getName());
    private CryptoPlugin cryptoPlugin;
    private ScriptingBrowser browser;
    private SignerParameters parameters;
    private SignStatus status;

    public void init() {
        String log_method = "init".intern();
        this.logger.entering(LOG_SOURCE_CLASS, log_method);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExoSignerApplet.this.initializeGUI();
            }
        });
        super.init();
        this.logger.exiting(LOG_SOURCE_CLASS, log_method);
    }

    public void initializeGUI() {
        this.setSize(new Dimension(222, 155));
        this.status = new SignStatus(222, 155);
        this.status.showSigning();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(null);
        contentPane.add((Component)this.status.getShowingLabel(), null);
        this.add(contentPane);
        this.repaint();
    }

    public void setBrowser(ScriptingBrowser browser) {
        this.browser = browser;
    }

    private SignerParameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new SignerParameters(this);
        }
        return this.parameters;
    }

    public void addPlugin(AppletPlugin plugin) {
        if (plugin instanceof CryptoPlugin) {
            this.cryptoPlugin = (CryptoPlugin)plugin;
        }
    }

    private void showMessage(String msg) {
        this.browser.getWindow().call("userMessage", new Object[]{msg});
    }

    public Object invoke(String methodName, String[] args) {
        String result = null;
        if ("signInputDigest".equals(methodName)) {
            result = this.signInputDigest(args[0], args[1]);
        } else if ("showMessage".equals(methodName)) {
            this.showMessage(args[0]);
        }
        return result;
    }

    public String signInputDigest(String keyStoreFile, String keyStorePassword) {
        String log_method = "signInputDigest".intern();
        this.logger.entering(LOG_SOURCE_CLASS, log_method);
        SignerParameters params = this.getParameters();
        String formName = params.getSigningFormNameParam();
        String encodedDigestFieldName = params.getEncodedDigestFieldNameParam();
        String encodedDigest = this.getFormField(formName, encodedDigestFieldName);
        byte[] hash = SignerUtil.base64Decode(encodedDigest);
        SignatureInfo sinfo = null;
        try {
            String algorithm = this.getAlgorithm();
            sinfo = this.sign(hash, algorithm, keyStoreFile, keyStorePassword);
        }
        catch (ExoSignerException e) {
            this.logger.throwing(LOG_SOURCE_CLASS, log_method, (Throwable)e);
            this.doFailure(e.getMessage());
            return FALSE;
        }
        String signatureFieldName = params.getSignatureFieldNameParam();
        String certChainFieldName = params.getCerticateChainFieldNameParam();
        String encodedSignature = SignerUtil.base64Encode(sinfo.getSignature());
        String encodedCertPath = SignerUtil.base64Encode(sinfo.getCertPath());
        this.setFormField(formName, signatureFieldName, encodedSignature);
        this.setFormField(formName, certChainFieldName, encodedCertPath);
        this.doSuccess();
        return TRUE;
    }

    private void doSuccess() {
        this.status.showSigning();
    }

    private void doFailure(String message) {
        this.status.showFailure();
        this.showMessage(message);
    }

    private SignatureInfo sign(byte[] hash, String algorithm, String keyStoreFile, String keyStorePassword) throws ExoSignerException {
        SignatureInfo signInfo = new SignatureInfo();
        Object userKeyStore = this.loadUserKeyStore(keyStoreFile, keyStorePassword);
        byte[] certPath = this.getCertPath(userKeyStore);
        signInfo.setCertPath(certPath);
        Object signingKey = this.getPrivateKey(userKeyStore, keyStorePassword);
        byte[] signature = this.doSign(hash, algorithm, signingKey);
        signInfo.setSignature(signature);
        return signInfo;
    }

    private byte[] doSign(byte[] hash, String algorithm, Object privateKey) throws ExoSignerException {
        byte[] signature = null;
        try {
            signature = this.cryptoPlugin.sign(hash, algorithm, privateKey);
        }
        catch (CryptoException e) {
            throw new ExoSignerException("Signing failed. " + e.getMessage(), e);
        }
        return signature;
    }

    private String getAlgorithm() {
        SignerParameters params = this.getParameters();
        String algo = params.getAlgorithmParam();
        if (algo == null) {
            algo = DEFAULT_ALGORITHM;
        }
        return algo;
    }

    private byte[] getCertPath(Object keyStore) throws ExoSignerException {
        byte[] certPath = null;
        try {
            Object[] chain = this.cryptoPlugin.getCertificationChain(keyStore);
            if (chain == null) {
                throw new ExoSignerException("Unable to extract certificate chain from user certificate KeyStore.");
            }
            certPath = this.cryptoPlugin.getCertPath(chain, DEFAULT_CERTIFICATE_TYPE);
        }
        catch (CryptoException e) {
            throw new ExoSignerException("Unable to extract certificate chain from user certificate KeyStore.", e);
        }
        return certPath;
    }

    private Object getPrivateKey(Object keyStore, String password) throws ExoSignerException {
        Object key = null;
        try {
            key = this.cryptoPlugin.getPrivateKey(keyStore, password);
        }
        catch (CryptoException e) {
            throw new ExoSignerException("Failed to load Private Key.", e);
        }
        return key;
    }

    private Object loadUserKeyStore(String path, String password) throws ExoSignerException {
        Object keyStore = null;
        File file = new File(path);
        try {
            keyStore = this.cryptoPlugin.loadKeyStore(file, password, "PKCS12");
        }
        catch (CryptoException e) {
            throw new ExoSignerException("Failed to load user certificate KeyStore.", e);
        }
        return keyStore;
    }

    private String getFormField(String formName, String fieldName) {
        ScriptingObject form = this.browser.getForm(formName);
        ScriptingObject field = (ScriptingObject)form.getMember(fieldName);
        String value = this.browser.getMemberValue((Object)field);
        return value;
    }

    private void setFormField(String formName, String fieldName, Object value) {
        ScriptingObject form = this.browser.getForm(formName);
        ScriptingObject field = (ScriptingObject)form.getMember(fieldName);
        this.browser.setMemberValue((Object)field, value);
    }
}

