/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.signerclient;

import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class SignStatus {
    private static final String SIGNING_IMAGE = "/images/signing.jpg";
    private static final String SUCCESS_IMAGE = "/images/ok.jpg";
    private static final String FAILURE_IMAGE = "/images/fail.jpg";
    private JLabel showing = new JLabel("Loading images...");
    private static final long serialVersionUID = 1L;

    public SignStatus(int width, int height) {
        this.showing.setBounds(0, 0, width, height);
        this.showing.setHorizontalAlignment(0);
        this.showing.setVerticalAlignment(0);
        this.showing.setHorizontalTextPosition(0);
        this.showing.setVerticalTextPosition(0);
    }

    public JLabel getShowingLabel() {
        return this.showing;
    }

    private void showImage(String image) {
        ImageIcon imgSrc = SignStatus.loadImage(image);
        this.showing.setIcon(imgSrc);
        this.showing.setText("");
        this.showing.repaint();
    }

    public void showSigning() {
        this.showImage(SIGNING_IMAGE);
    }

    public void showSuccess() {
        this.showImage(SUCCESS_IMAGE);
    }

    public void showFailure() {
        this.showImage(FAILURE_IMAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageIcon loadImage(String image) {
        ImageIcon icon = null;
        BufferedInputStream istream = new BufferedInputStream(SignStatus.class.getResourceAsStream(image));
        if (istream != null) {
            byte[] buffer = new byte[16384];
            try {
                int count = istream.read(buffer);
                if (count == 0) {
                    ImageIcon imageIcon = null;
                    return imageIcon;
                }
            }
            catch (IOException e) {
                ImageIcon imageIcon = null;
                return imageIcon;
            }
            finally {
                try {
                    istream.close();
                }
                catch (IOException e) {
                    return null;
                }
            }
            icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(buffer));
            Object var3_3 = null;
        }
        return icon;
    }
}

