/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.signerclient.crypto.jce;

import java.io.File;
import java.io.FileInputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.exoplatform.applet.plugin.AppletPlugin;
import org.exoplatform.applet.security.RestrictedAction;
import org.exoplatform.applet.security.RestrictedActor;
import org.exoplatform.applications.signerclient.crypto.CryptoException;
import org.exoplatform.applications.signerclient.crypto.CryptoPlugin;
import org.exoplatform.applications.signerclient.crypto.jce.Signer;
import org.exoplatform.applications.signerclient.crypto.jce.SignerFactory;

public class JCECryptoPlugin
implements AppletPlugin,
CryptoPlugin,
RestrictedActor {
    private RestrictedAction access;

    public String getName() {
        return "JCECrytpoPlugin";
    }

    public String getDescription() {
        return "eXo Applet plugin providing crytpo functionalities.";
    }

    public void setTrustAccess(RestrictedAction access) {
        this.access = access;
    }

    public byte[] sign(byte[] hash, String algorithm, Object privateKey) throws CryptoException {
        byte[] signature = null;
        Signer signer = SignerFactory.getSigner(hash, algorithm);
        if (signer == null) {
            throw new CryptoException("No signer found for algorithm: " + algorithm);
        }
        try {
            signer.initSign((PrivateKey)privateKey);
            signature = signer.sign();
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new CryptoException(e.getMessage(), e);
        }
        return signature;
    }

    public Object[] getCertificationChain(Object keyStore) throws CryptoException {
        Object[] certs = null;
        try {
            KeyStore store = (KeyStore)keyStore;
            certs = store.getCertificateChain(JCECryptoPlugin.getFirstAlias(store));
        }
        catch (KeyStoreException e) {
            throw new CryptoException("Failed to retrieve certificate chain from keystore.", e);
        }
        return certs;
    }

    public byte[] getCertPath(Object[] certChain, String type) throws CryptoException {
        byte[] encodedCertPath = null;
        try {
            Certificate[] certs = (Certificate[])certChain;
            List<Certificate> inChain = Arrays.asList(certs);
            CertificateFactory cfactory = CertificateFactory.getInstance(type);
            CertPath cp = cfactory.generateCertPath(inChain);
            encodedCertPath = cp.getEncoded();
        }
        catch (CertificateException e) {
            throw new CryptoException(e.getMessage(), e);
        }
        return encodedCertPath;
    }

    public Object getPrivateKey(Object keyStore, String password) throws CryptoException {
        PrivateKey privateKey = null;
        KeyStore store = (KeyStore)keyStore;
        try {
            privateKey = (PrivateKey)store.getKey(this.getKeyAlias(store), password.toCharArray());
        }
        catch (KeyStoreException e) {
            throw new CryptoException("Failed to retrieve certificate chain from keystore.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e.getMessage(), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoException(e.getMessage(), e);
        }
        return privateKey;
    }

    private String getKeyAlias(KeyStore store) throws KeyStoreException {
        String keyAlias;
        block0: {
            String aliasName;
            keyAlias = null;
            Enumeration<String> aliases = store.aliases();
            if (!aliases.hasMoreElements() || !store.isKeyEntry(aliasName = aliases.nextElement())) break block0;
            keyAlias = aliasName;
        }
        return keyAlias;
    }

    public Object loadKeyStore(File ksFile, String ksPassword, String ksType) throws CryptoException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(ksType);
            FileInputStream keyStoreStream = this.access.getFileInputStream(ksFile);
            keyStore.load(keyStoreStream, ksPassword.toCharArray());
        }
        catch (Exception e) {
            throw new CryptoException(e.getMessage(), e);
        }
        return keyStore;
    }

    private static String getFirstAlias(KeyStore keyStore) throws KeyStoreException {
        String firstAlias = null;
        Enumeration<String> aliases = keyStore.aliases();
        if (aliases.hasMoreElements()) {
            firstAlias = aliases.nextElement();
        }
        return firstAlias;
    }
}

