/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.signerclient.crypto.jce;

import org.exoplatform.applications.signerclient.crypto.jce.RSASigner;
import org.exoplatform.applications.signerclient.crypto.jce.Signer;

public class SignerFactory {
    private static final String SHA1_WITH_RSA = "SHA1withRSA".intern();
    private static final String SHA224_WITH_RSA = "SHA224withRSA".intern();
    private static final String SHA256_WITH_RSA = "SHA256withRSA".intern();
    private static final String SHA384_WITH_RSA = "SHA384withRSA".intern();
    private static final String SHA512_WITH_RSA = "SHA512withRSA".intern();
    private static final String MD2_WITH_RSA = "MD2withRSA".intern();
    private static final String MD4_WITH_RSA = "MD4withRSA".intern();
    private static final String MD5_WITH_RSA = "MD5withRSA".intern();

    private SignerFactory() {
    }

    public static Signer getSigner(byte[] hash, String algorithm) {
        RSASigner instance = null;
        if (SHA1_WITH_RSA.equals(algorithm)) {
            instance = new RSASigner.SHA1WithRSAEncryption(hash);
        } else if (SHA224_WITH_RSA.equals(algorithm)) {
            instance = new RSASigner.SHA224WithRSAEncryption(hash);
        } else if (SHA256_WITH_RSA.equals(algorithm)) {
            instance = new RSASigner.SHA256WithRSAEncryption(hash);
        } else if (SHA384_WITH_RSA.equals(algorithm)) {
            instance = new RSASigner.SHA384WithRSAEncryption(hash);
        } else if (SHA512_WITH_RSA.equals(algorithm)) {
            instance = new RSASigner.SHA512WithRSAEncryption(hash);
        } else if (MD2_WITH_RSA.equals(algorithm)) {
            instance = new RSASigner.MD2WithRSAEncryption(hash);
        } else if (MD4_WITH_RSA.equals(algorithm)) {
            instance = new RSASigner.MD4WithRSAEncryption(hash);
        } else if (MD5_WITH_RSA.equals(algorithm)) {
            instance = new RSASigner.MD5WithRSAEncryption(hash);
        }
        return instance;
    }
}

