/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.cms;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Value;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.faces.cms.CMSUtils;
import org.exoplatform.faces.cms.CMSViewComponent;
import org.exoplatform.faces.cms.PortalHook;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.grammar.wiki.WikiContext;
import org.exoplatform.services.grammar.wiki.WikiEngineService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSDelegate
implements CMSViewComponent {
    private String portalName_;
    private WikiContext wikiContext;
    private WikiEngineService service_;
    private Node node_;

    public CMSDelegate(Node node) {
        this.node_ = node;
        PortalContainer pcontainer = PortalContainer.getInstance();
        PortalContainerInfo info = (PortalContainerInfo)pcontainer.getComponentInstanceOfType(PortalContainerInfo.class);
        this.portalName_ = info.getContainerName();
        this.service_ = (WikiEngineService)pcontainer.getComponentInstanceOfType(WikiEngineService.class);
    }

    @Override
    public String getPortalName() {
        return this.portalName_;
    }

    @Override
    public String getWorkspaceName() throws Exception {
        return this.node_.getSession().getWorkspace().getName();
    }

    @Override
    public Node getNode() throws Exception {
        return this.node_;
    }

    @Override
    public void setNode(Node node) {
        this.node_ = node;
    }

    @Override
    public boolean isNodeTypeSupported() {
        try {
            TemplateService templateService = (TemplateService)PortalContainer.getComponent(TemplateService.class);
            String nodeTypeName = this.node_.getPrimaryNodeType().getName();
            return templateService.isManagedNodeType(nodeTypeName);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getNodeType() throws Exception {
        return this.node_.getPrimaryNodeType().getName();
    }

    @Override
    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(className);
            PortalContainer container = PortalContainer.getInstance();
            service = container.getComponentInstanceOfType(clazz);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return service;
    }

    @Override
    public WikiContext getWikiContext() {
        if (this.wikiContext == null) {
            this.wikiContext = new WikiContext();
            this.wikiContext.put((Object)"portalHook", (Object)new PortalHook());
        }
        return this.wikiContext;
    }

    @Override
    public WikiEngineService getWikiService() {
        return this.service_;
    }

    @Override
    public boolean isRssLink() {
        return false;
    }

    @Override
    public String getRssLink() {
        return null;
    }

    @Override
    public String getTemplatePath() throws Exception {
        String nodeTypeName = this.node_.getPrimaryNodeType().getName();
        PortalContainer container = PortalContainer.getInstance();
        TemplateService templateService = (TemplateService)container.getComponentInstanceOfType(TemplateService.class);
        return templateService.getTemplatePath(false, nodeTypeName);
    }

    @Override
    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        try {
            Value[] vals = this.node_.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node currentNode = this.node_.getSession().getNodeByUUID(uuid);
                relations.add(currentNode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return relations;
    }

    @Override
    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        String nodeType = "";
        NodeIterator childrenIterator = this.node_.getNodes();
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            try {
                nodeType = childNode.getPrimaryNodeType().getName();
                if (!"nt:file".equals(nodeType)) continue;
                attachments.add(childNode);
            }
            catch (Exception e) {}
        }
        return attachments;
    }

    @Override
    public String getAttachmentSize(Node node) {
        Node jcrContentNode = null;
        int size = 0;
        String sSize = "0";
        String nodeType = "";
        try {
            nodeType = node.getPrimaryNodeType().getName();
        }
        catch (Exception ex) {
            nodeType = "default";
        }
        try {
            if ("nt:file".equals(nodeType)) {
                jcrContentNode = node.getNode("jcr:content");
            } else if ("nt:resource".equals(nodeType)) {
                jcrContentNode = node;
            }
            if (jcrContentNode != null) {
                int len;
                Property data = null;
                if (jcrContentNode.hasProperty("jcr:data")) {
                    data = jcrContentNode.getProperty("jcr:data");
                }
                InputStream is = data.getValue().getStream();
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) > 0) {
                    size += len;
                }
                is.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (size > 0) {
            sSize = String.valueOf((float)(size / 100) / 10.0f);
        }
        sSize = sSize + " Kb";
        return sSize;
    }

    @Override
    public boolean hasPropertyContent(Node node, String property) {
        try {
            String value = node.getProperty(property).getString();
            if (value.length() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public List getSupportedLocalise() throws Exception {
        ArrayList<String> local = new ArrayList<String>();
        if (this.node_.hasNode("languages")) {
            Node languages = this.node_.getNode("languages");
            NodeIterator iter = languages.getNodes();
            while (iter.hasNext()) {
                local.add(iter.nextNode().getName());
            }
            local.add(this.node_.getProperty("exo:language").getString());
        }
        return local;
    }

    @Override
    public String getLargeNodeTypeIcon(Node node) {
        return CMSUtils.getLargeNodeTypeIcon(node);
    }

    @Override
    public String getSmallNodeTypeIcon(Node node) {
        return CMSUtils.getSmallNodeTypeIcon(node);
    }

    @Override
    public String getPropertyIconByName(String propertyName) {
        return CMSUtils.getPropertyIconByName(propertyName);
    }

    @Override
    public String getPropertyTypeIcon(Property property) {
        return CMSUtils.getPropertyTypeIcon(property);
    }
}

