/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.cms;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.faces.core.component.UISimpleForm;
import org.exoplatform.faces.core.component.UIUploadInput;
import org.exoplatform.portal.session.PortalResources;
import org.exoplatform.services.cms.JcrInputProperty;

public class CMSUtils {
    private static Map smallNodeTypeIconMapping_;
    private static Map largeNodeTypeIconMapping_;
    private static Map propertyTypeIconMapping_;
    private static String defaultSmallNodeIcon_;
    private static String defaultLargeNodeIcon_;
    private static String defaultPropertyIcon_;
    private static boolean isReferenceNode_;
    public static final String JCR_INFO = "jcrInfo";

    public static Map prepareMap(UISimpleForm uiForm) {
        HashMap<String, JcrInputProperty> rawinputs = new HashMap<String, JcrInputProperty>();
        Map inputs = uiForm.getUIInputs();
        Set keys = inputs.keySet();
        Object value = null;
        for (String key : keys) {
            UIInput input = (UIInput)inputs.get(key);
            JcrInputProperty property = (JcrInputProperty)input.getProperty(JCR_INFO);
            if (property == null) continue;
            if (uiForm.isMultiValue(key)) {
                List multiInputs = uiForm.getMultipleValuesUIInput(key);
                ArrayList<String> values = new ArrayList<String>();
                for (UIInput multiInput : multiInputs) {
                    values.add(multiInput.getValue());
                }
                property.setValue((Object)values.toArray(new String[values.size()]));
            } else {
                value = input instanceof UIUploadInput ? (Object)((UIUploadInput)input).getContent() : input.getValue();
                property.setValue(value);
            }
            rawinputs.put(property.getJcrPath(), property);
        }
        return rawinputs;
    }

    public static void setReference(boolean b) {
        isReferenceNode_ = b;
    }

    public static String getIconByNodeTypeName(String nodeType) {
        String icon;
        if (smallNodeTypeIconMapping_ == null) {
            smallNodeTypeIconMapping_ = CMSUtils.getSubProperties("NodeType.icon.small.");
            defaultSmallNodeIcon_ = (String)smallNodeTypeIconMapping_.get("default");
        }
        if ((icon = (String)smallNodeTypeIconMapping_.get(nodeType)) == null) {
            icon = defaultSmallNodeIcon_;
        }
        return icon;
    }

    public static String getSmallNodeTypeIcon(Node node) {
        String icon;
        String nodeType = CMSUtils.getNodeType(node);
        if (smallNodeTypeIconMapping_ == null) {
            smallNodeTypeIconMapping_ = CMSUtils.getSubProperties("NodeType.icon.small.");
            defaultSmallNodeIcon_ = (String)smallNodeTypeIconMapping_.get("default");
        }
        if ((icon = CMSUtils.getFileIcon(node, nodeType, true)) != null) {
            return icon;
        }
        if (isReferenceNode_) {
            icon = (String)smallNodeTypeIconMapping_.get(nodeType + "_reference");
            isReferenceNode_ = false;
        } else {
            icon = (String)smallNodeTypeIconMapping_.get(nodeType);
        }
        if (icon == null) {
            icon = defaultSmallNodeIcon_;
        }
        return icon;
    }

    public static String getLargeNodeTypeIcon(Node node) {
        String icon;
        String nodeType = CMSUtils.getNodeType(node);
        if (largeNodeTypeIconMapping_ == null) {
            largeNodeTypeIconMapping_ = CMSUtils.getSubProperties("NodeType.icon.large.");
            defaultLargeNodeIcon_ = (String)largeNodeTypeIconMapping_.get("default");
        }
        if ((icon = CMSUtils.getFileIcon(node, nodeType, false)) != null) {
            return icon;
        }
        if (isReferenceNode_) {
            icon = (String)largeNodeTypeIconMapping_.get(nodeType + "_reference");
            isReferenceNode_ = false;
        } else {
            icon = (String)largeNodeTypeIconMapping_.get(nodeType);
        }
        if (icon == null) {
            icon = defaultLargeNodeIcon_;
        }
        return icon;
    }

    private static String getFileIcon(Node node, String nodeType, boolean isSmall) {
        Node jcrContentNode = null;
        try {
            if ("nt:file".equals(nodeType)) {
                jcrContentNode = node.getNode("jcr:content");
            } else if ("nt:resource".equals(nodeType)) {
                jcrContentNode = node;
            }
            if (jcrContentNode != null) {
                String mimeType = null;
                if (jcrContentNode.hasProperty("jcr:mimeType")) {
                    mimeType = jcrContentNode.getProperty("jcr:mimeType").getString();
                }
                if (isSmall) {
                    return (String)smallNodeTypeIconMapping_.get(nodeType + "." + mimeType);
                }
                return (String)largeNodeTypeIconMapping_.get(nodeType + "." + mimeType);
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return null;
    }

    public static String toHTML(String str) {
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\n", "<br>");
        str = str.replaceAll("--", "&ndash; &ndash;");
        str = str.replaceAll("\t", "&#09;");
        str = str.replaceAll(" ", "&nbsp;");
        return str;
    }

    private static String getNodeType(Node node) {
        String nodeType = "";
        try {
            nodeType = node.getPrimaryNodeType().getName();
        }
        catch (Exception ex) {
            nodeType = "default";
        }
        return nodeType;
    }

    public static String getPropertyTypeIcon(Property property) {
        String icon;
        String name = "";
        try {
            name = property.getName();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (propertyTypeIconMapping_ == null) {
            propertyTypeIconMapping_ = CMSUtils.getSubProperties("PropertyType.icon.");
            defaultPropertyIcon_ = (String)propertyTypeIconMapping_.get("default");
        }
        if ((icon = (String)propertyTypeIconMapping_.get(name)) == null) {
            icon = defaultPropertyIcon_;
        }
        return icon;
    }

    public static String getPropertyIconByName(String propertyName) {
        String icon;
        if (propertyTypeIconMapping_ == null) {
            propertyTypeIconMapping_ = CMSUtils.getSubProperties("PropertyType.icon.");
            defaultPropertyIcon_ = (String)propertyTypeIconMapping_.get("default");
        }
        if ((icon = (String)propertyTypeIconMapping_.get(propertyName)) == null) {
            icon = defaultPropertyIcon_;
        }
        return icon;
    }

    private static Map getSubProperties(String prefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        ResourceBundle res = CMSUtils.getPortalBundle();
        Enumeration<String> e = res.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (!key.startsWith(prefix)) continue;
            String newkey = key.substring(prefix.length(), key.length());
            map.put(newkey, res.getString(key));
        }
        return map;
    }

    public static ResourceBundle getPortalBundle() {
        PortalResources portalResources = (PortalResources)SessionContainer.getComponent(PortalResources.class);
        return portalResources.getApplicationResource();
    }

    public static String getAttachmentSize(Node node) {
        Node jcrContentNode = null;
        int size = 0;
        String sSize = "0";
        String nodeType = "";
        try {
            nodeType = node.getPrimaryNodeType().getName();
        }
        catch (Exception ex) {
            nodeType = "default";
        }
        try {
            if ("nt:file".equals(nodeType)) {
                jcrContentNode = node.getNode("jcr:content");
            } else if ("nt:resource".equals(nodeType)) {
                jcrContentNode = node;
            }
            if (jcrContentNode != null) {
                int len;
                Property data = null;
                if (jcrContentNode.hasProperty("jcr:data")) {
                    data = jcrContentNode.getProperty("jcr:data");
                }
                InputStream is = data.getValue().getStream();
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) > 0) {
                    size += len;
                }
                is.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (size > 0) {
            sSize = String.valueOf((float)(size / 100) / 10.0f);
        }
        sSize = sSize + " Kb";
        return sSize;
    }

    static {
        isReferenceNode_ = false;
    }
}

