/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.cms;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.cms.InputInfo;
import org.exoplatform.faces.core.component.UICalendarInput;
import org.exoplatform.faces.core.component.UIDateInput;
import org.exoplatform.faces.core.component.UIImageUploadInput;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.faces.core.component.UIStringInput;
import org.exoplatform.faces.core.component.UITextArea;
import org.exoplatform.faces.core.component.UIUploadInput;
import org.exoplatform.faces.core.component.UIWYSIWYG;
import org.exoplatform.services.idgenerator.IDGeneratorService;

public class DialogUtil {
    private static final String TEXT = "text";
    private static final String TEXTAREA = "textarea";
    private static final String WYSIWYG = "wysiwyg";
    private static final String DATE = "date";
    private static final String UPLOAD = "upload";
    private static final String IMAGE_UPLOAD = "imageupload";
    private static final String CALENDAR = "calendar";

    public static List getUIInputs(Node dialog) throws Exception {
        ArrayList inputs = new ArrayList();
        Node node = dialog.getNode("node");
        DialogUtil.buildRecursively(node, inputs);
        return inputs;
    }

    public static void buildRecursively(Node currentNode, List inputs) throws Exception {
        PropertyIterator propertyIterator = currentNode.getProperties();
        String component = "";
        String label = "";
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            String name = property.getName();
            if ("component".equals(name)) {
                component = property.getString();
                continue;
            }
            if (!"label".equals(name)) continue;
            label = property.getString();
        }
        IDGeneratorService idGenerator = (IDGeneratorService)PortalContainer.getComponent(IDGeneratorService.class);
        String id = "a" + idGenerator.generateStringID((Object)currentNode);
        InputInfo input = new InputInfo(id, currentNode.getPath(), label, DialogUtil.getComponent(id, component), false);
        inputs.add(input);
        NodeIterator nodeIterator = currentNode.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            DialogUtil.buildRecursively(node, inputs);
        }
    }

    private static UIInput getComponent(String key, String component) {
        if (component == null || TEXT.equals(component)) {
            return new UIStringInput(key, "");
        }
        if (TEXTAREA.equals(component)) {
            return new UITextArea(key, "");
        }
        if (WYSIWYG.equals(component)) {
            return new UIWYSIWYG(key, "");
        }
        if (DATE.equals(component)) {
            return new UIDateInput(key, new Date());
        }
        if (UPLOAD.equals(component)) {
            return new UIUploadInput(key);
        }
        if (IMAGE_UPLOAD.equals(component)) {
            return new UIImageUploadInput(key);
        }
        if (CALENDAR.equals(component)) {
            return new UICalendarInput(key, "");
        }
        return null;
    }
}

