/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.cms.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.exoplatform.Constants;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.application.ExoFacesMessage;
import org.exoplatform.faces.cms.CMSUtils;
import org.exoplatform.faces.core.Selector;
import org.exoplatform.faces.core.SelectorHandler;
import org.exoplatform.faces.core.component.UIExoCommand;
import org.exoplatform.faces.core.component.model.Parameter;
import org.exoplatform.faces.core.event.ExoActionEvent;
import org.exoplatform.faces.core.event.ExoActionListener;
import org.exoplatform.portal.Information;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;

public class JcrBrowser
extends UIExoCommand
implements Selector {
    static String CHANGE_NODE = "changeNode";
    static String SELECT_NODE = "selectNode";
    static Parameter[] CHANGE_NODE_PARAMS = new Parameter[]{new Parameter("op", CHANGE_NODE)};
    static Parameter[] SELECT_NODE_PARAMS = new Parameter[]{new Parameter("op", SELECT_NODE)};
    static Parameter[] CANCEL_PARAMS = new Parameter[]{new Parameter("op", CANCEL_ACTION)};
    private static Map smallNodeTypeIconMapping_;
    private Node cmsRootNode_;
    private Node selectedNode_;
    private Node parentNode_;
    private SelectorHandler handler_;
    private String info_;
    private Session session;
    private String[] parameters_;
    private List selectFilter_;

    public JcrBrowser() throws Exception {
        this.setRendererType("VelocityRenderer");
        this.setId("JcrBrowser");
        this.addActionListener(ChangeNodeActionListener.class, CHANGE_NODE);
        this.addActionListener(SelectNodeActionListener.class, SELECT_NODE);
        this.addActionListener(CancelActionListener.class, CANCEL_ACTION);
    }

    public void setSession(Session session) throws RepositoryException {
        this.session = session;
        this.selectedNode_ = session.getRootNode();
        this.parentNode_ = null;
    }

    public Session getSession(String workspace) {
        PortalContainer pC = PortalContainer.getInstance();
        RepositoryService rS = (RepositoryService)pC.getComponentInstanceOfType(RepositoryService.class);
        Session session = null;
        try {
            ManageableRepository repository = rS.getRepository();
            session = workspace == null ? repository.login() : rS.getRepository().getSystemSession(workspace);
            this.selectedNode_ = session.getRootNode();
            this.parentNode_ = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return session;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = this.getSession(null);
        }
        return this.session;
    }

    public void setHandler(SelectorHandler handler) {
        this.handler_ = handler;
    }

    public void setParameters(String[] args) {
        Node selectedNode;
        this.parameters_ = args;
        String workspace = args[0];
        this.session = this.getSession(workspace);
        String path = null;
        path = args.length > 1 ? args[1] : "/";
        try {
            selectedNode = path.startsWith("/") ? (Node)this.session.getItem(path) : (Node)this.session.getItem("/" + path);
        }
        catch (RepositoryException e) {
            return;
        }
        this.cmsRootNode_ = selectedNode;
        this.selectedNode_ = selectedNode;
    }

    public String[] getParameters() {
        return this.parameters_;
    }

    public String getInfo() {
        return this.info_;
    }

    public void setInfo(String info) {
        this.info_ = info;
    }

    public Parameter[] getChangeNodeParams() {
        return CHANGE_NODE_PARAMS;
    }

    public Parameter[] getSelectNodeParams() {
        return SELECT_NODE_PARAMS;
    }

    public Parameter[] getCancelParams() {
        return CANCEL_PARAMS;
    }

    public Node getSelectedNode() {
        return this.selectedNode_;
    }

    public Node getParentNode() {
        return this.parentNode_;
    }

    public String getInputValue() {
        String rootNodePath = null;
        try {
            rootNodePath = this.cmsRootNode_.getPath();
            if (this.selectedNode_ == null) {
                return rootNodePath;
            }
            return this.selectedNode_.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return rootNodePath;
        }
    }

    public List getFilter() {
        return this.selectFilter_;
    }

    public void setFilter(List filter) {
        this.selectFilter_ = filter;
    }

    public String getSelectedNodePath() throws Exception {
        return this.getInputValue();
    }

    public String getParentNodePath() throws Exception {
        if (this.parentNode_ == null) {
            return "";
        }
        return this.parentNode_.getPath();
    }

    public Collection getSelectedChildrenNodes() throws Exception {
        if (this.selectedNode_ == null) {
            return Constants.EMPTY_LIST;
        }
        NodeIterator iter = this.selectedNode_.getNodes();
        ArrayList<Node> nodesPaths = new ArrayList<Node>();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            nodesPaths.add(node);
        }
        return nodesPaths;
    }

    public Collection getParentChildrenNodes() throws Exception {
        if (this.parentNode_ == null) {
            return Constants.EMPTY_LIST;
        }
        NodeIterator iter = this.parentNode_.getNodes();
        ArrayList<Node> nodesPaths = new ArrayList<Node>();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            nodesPaths.add(node);
        }
        return nodesPaths;
    }

    public void changeNode(String nodePath) throws Exception {
        if (nodePath.length() >= this.cmsRootNode_.getPath().length() && nodePath.indexOf(this.cmsRootNode_.getPath()) > -1) {
            String parentPath;
            this.selectedNode_ = (Node)this.getSession().getItem(nodePath);
            this.parentNode_ = !nodePath.equals("/") ? ((parentPath = this.selectedNode_.getParent().getPath()).indexOf(this.cmsRootNode_.getPath()) > -1 ? this.selectedNode_.getParent() : null) : null;
        } else {
            this.selectedNode_ = this.cmsRootNode_;
            this.parentNode_ = null;
        }
    }

    public String getSmallNodeTypeIcon(Node node) throws Exception {
        return CMSUtils.getSmallNodeTypeIcon(node);
    }

    public static class CancelActionListener
    extends ExoActionListener {
        public void execute(ExoActionEvent event) throws Exception {
            JcrBrowser uiComp = (JcrBrowser)((Object)event.getSource());
            uiComp.handler_.cancel((Selector)uiComp);
        }
    }

    public static class SelectNodeActionListener
    extends ExoActionListener {
        public void execute(ExoActionEvent event) throws Exception {
            JcrBrowser uiComp = (JcrBrowser)((Object)event.getSource());
            Information iprovider = this.findInformationProvider((UIComponent)uiComp);
            String selectedPath = event.getParameter("objectId");
            Node currentNode = uiComp.selectedNode_;
            uiComp.selectedNode_ = (Node)uiComp.getSession().getItem(selectedPath);
            try {
                uiComp.handler_.select((Selector)uiComp);
            }
            catch (ValueFormatException vfe) {
                vfe.printStackTrace();
                uiComp.selectedNode_ = currentNode;
                iprovider.addMessage((FacesMessage)new ExoFacesMessage(FacesMessage.SEVERITY_ERROR, "Can not add mixin because this node already have property same name with mixin's property but diffrences definition of property's value type.Please check definition of this nodetype and definition of mixin nodetype for more detail."));
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                iprovider.addMessage((FacesMessage)new ExoFacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage()));
                return;
            }
        }
    }

    public static class ChangeNodeActionListener
    extends ExoActionListener {
        public void execute(ExoActionEvent event) throws Exception {
            JcrBrowser uiComp = (JcrBrowser)((Object)event.getSource());
            String nodePath = event.getParameter("objectId");
            try {
                uiComp.changeNode(nodePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

