/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.velocity.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UICommand;
import javax.faces.event.ActionListener;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faces.cms.CMSUtils;
import org.exoplatform.faces.core.component.UISimpleForm;
import org.exoplatform.faces.core.event.ActionInterceptor;
import org.exoplatform.faces.core.event.ExoActionEvent;
import org.exoplatform.faces.core.event.ExoActionListener;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptService;

public class InterceptorDirective
extends Directive {
    public String getName() {
        return "interceptor";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        ActionListener[] actionListeners;
        UISimpleForm uiForm = (UISimpleForm)context.get("uicomponent");
        String preSave = (String)node.jjtGetChild(0).value(context);
        String postSave = (String)node.jjtGetChild(1).value(context);
        for (ActionListener actionListener : actionListeners = uiForm.getActionListeners()) {
            if (!(actionListener instanceof ExoActionListener)) continue;
            ExoActionListener exoListener = (ExoActionListener)actionListener;
            exoListener.removeTransientInterceptors();
            String actionName = exoListener.getActionName();
            if (uiForm.getCancelAction().equals(actionName)) continue;
            ExoActionInterceptor jsfInterceptor = new ExoActionInterceptor();
            if (preSave != null && !"".equals(preSave)) {
                jsfInterceptor.setPreSaveInterceptor(preSave);
            }
            if (postSave != null && !"".equals(postSave)) {
                jsfInterceptor.setPostSaveInterceptor(postSave);
            }
            exoListener.addInterceptor((ActionInterceptor)jsfInterceptor);
        }
        return false;
    }

    public class ExoActionInterceptor
    implements ActionInterceptor {
        private String preSaveInterceptor;
        private String postSaveInterceptor;

        public void setPostSaveInterceptor(String postSaveInterceptor) {
            this.postSaveInterceptor = postSaveInterceptor;
        }

        public void setPreSaveInterceptor(String preSaveInterceptor) {
            this.preSaveInterceptor = preSaveInterceptor;
        }

        public void preExecute(ExoActionEvent event) throws Exception {
            if (this.preSaveInterceptor == null) {
                return;
            }
            UISimpleForm uiForm = (UISimpleForm)event.getSource();
            Map sortedInputs = CMSUtils.prepareMap(uiForm);
            this.executeScript(this.preSaveInterceptor, sortedInputs);
        }

        public void postExecute(ExoActionEvent event) throws Exception {
            UICommand source = (UICommand)event.getComponent();
            if (this.postSaveInterceptor == null) {
                this.cleanInterceptors(source);
                return;
            }
            this.executeScript(this.postSaveInterceptor, event.getParameter("jcrPath"));
            this.cleanInterceptors(source);
        }

        private void executeScript(String script, Object o) {
            PortalContainer pC = PortalContainer.getInstance();
            ScriptService scriptService = (ScriptService)pC.getComponentInstanceOfType(ScriptService.class);
            try {
                CmsScript interceptorScript = scriptService.getScript(script);
                interceptorScript.execute(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private String extractNodeName(Set keys) {
            for (String key : keys) {
                if (!key.endsWith("node")) continue;
                return key;
            }
            return null;
        }

        public boolean isTransient() {
            return true;
        }

        private void cleanInterceptors(UICommand component) {
            ActionListener[] actionListeners;
            for (ActionListener actionListener : actionListeners = component.getActionListeners()) {
                if (!(actionListener instanceof ExoActionListener)) continue;
                ExoActionListener exoListener = (ExoActionListener)actionListener;
                exoListener.removeTransientInterceptors();
            }
        }
    }
}

