/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.velocity.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.faces.event.ActionListener;
import javax.jcr.Property;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.node.Node;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.faces.cms.CMSDialogComponent;
import org.exoplatform.faces.cms.SelectorHandlerImpl;
import org.exoplatform.faces.cms.listener.SelectorActionClassMaps;
import org.exoplatform.faces.cms.listener.SelectorActionListener;
import org.exoplatform.faces.cms.validator.QuartzCronExpressionValidator;
import org.exoplatform.faces.core.component.UICalendarInput;
import org.exoplatform.faces.core.component.UICheckBox;
import org.exoplatform.faces.core.component.UIExoComponent;
import org.exoplatform.faces.core.component.UIImageUploadInput;
import org.exoplatform.faces.core.component.UIInput;
import org.exoplatform.faces.core.component.UISelectBox;
import org.exoplatform.faces.core.component.UISimpleForm;
import org.exoplatform.faces.core.component.UIStringInput;
import org.exoplatform.faces.core.component.UITextArea;
import org.exoplatform.faces.core.component.UIUploadInput;
import org.exoplatform.faces.core.component.UIWYSIWYG;
import org.exoplatform.faces.core.component.model.SelectItem;
import org.exoplatform.faces.core.validator.EmailAddressValidator;
import org.exoplatform.faces.core.validator.EmptyFieldValidator;
import org.exoplatform.faces.core.validator.IdentifierValidator;
import org.exoplatform.faces.core.validator.NameValidator;
import org.exoplatform.faces.core.validator.NumberFormatValidator;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.velocity.directive.JSFFormField;

public class JSFDialogFormField
extends JSFFormField {
    private static final String SEPARATOR = "=";
    private static final String DUMMY_ACTION = "dummyAction";
    private static final String INPUT_NAME = "inputName=";
    private static final String JCR_PATH = "jcrPath=";
    private static final String WIDGET = "widget=";
    private static final String EDITABLE = "editable=";
    private static final String OPTIONS = "options=";
    private static final String VISIBLE = "visible=";
    private static final String NODETYPE = "nodetype=";
    private static final String MIXINTYPE = "mixintype=";
    private static final String SELECTOR_ACTION = "selectorAction=";
    private static final String SELECTOR_CLASS = "selectorClass=";
    private static final String SELECTOR_LABEL = "selectorLabel=";
    private static final String SELECTOR_PARAMS = "selectorParams=";
    private static final String SCRIPT = "script=";
    private static final String SCRIPT_PARAMS = "scriptParams=";
    private static final String MULTI_VALUES = "multiValues=";
    private static final String TEXT = "text";
    private static final String PASSWORD = "password";
    private static final String TEXTAREA = "textarea";
    private static final String WYSIWYG = "wysiwyg";
    private static final String UPLOAD = "upload";
    private static final String SELECTBOX = "selectbox";
    private static final String NAME_VALIDATOR = "nameValidator";
    private static final String EMAIL_ADDRESS_VALIDATOR = "emailValidator";
    private static final String EMPTY_FEILD_VALIDATOR = "emptyFieldValidator";
    private static final String NUMBER_FORMAT_VALIDATOR = "numberFormatValidator";
    private static final String IDENTIFIER_VALIDATOR = "identifierValidator";
    private static final String QUARTZ_CRON_EXPRESSION_VALIDATOR = "cronExpressionValidator";
    private static final String IMAGE_UPLOAD = "imageupload";
    private static final String CALENDAR = "calendar";
    private static final String DISPLAY_TIME = "displaytime";

    public String getName() {
        return "jsfDialogFormField";
    }

    public int getType() {
        return 2;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws Exception {
        super.init(rs, context, node);
    }

    public boolean render(InternalContextAdapter context, Writer w, Node node) throws IOException, MethodInvocationException, ResourceNotFoundException, ParseErrorException {
        UISimpleForm uiForm = (UISimpleForm)context.get("uicomponent");
        String name = null;
        String jcrPath = null;
        String widget = TEXT;
        String editable = "true";
        String defaultValue = "";
        String options = null;
        String visible = "true";
        String nodetype = null;
        String mixintype = null;
        String selectorAction = null;
        String selectorClass = null;
        String selectorLabel = null;
        String selectorParams = null;
        String script = null;
        String[] scriptParams = null;
        String multiValues = null;
        int size = node.jjtGetNumChildren();
        for (int i = 0; i < size; ++i) {
            String argument = (String)node.jjtGetChild(i).value(context);
            if (argument.startsWith(INPUT_NAME)) {
                name = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(WIDGET)) {
                widget = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(EDITABLE)) {
                editable = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(OPTIONS)) {
                options = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(VISIBLE)) {
                visible = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(NODETYPE)) {
                nodetype = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(MIXINTYPE)) {
                mixintype = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_ACTION)) {
                selectorAction = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_CLASS)) {
                selectorClass = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_LABEL)) {
                selectorLabel = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_PARAMS)) {
                selectorParams = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SCRIPT)) {
                script = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SCRIPT_PARAMS)) {
                String params = argument.substring(argument.indexOf(SEPARATOR) + 1);
                scriptParams = StringUtils.split((String)params, (String)",");
                continue;
            }
            if (argument.startsWith(MULTI_VALUES)) {
                multiValues = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            defaultValue = argument;
        }
        javax.jcr.Node jcrNode = null;
        try {
            jcrNode = ((CMSDialogComponent)uiForm).getNode();
        }
        catch (Exception e) {
            // empty catch block
        }
        UIInput uiInput = uiForm.getUIInput(name);
        if (uiInput == null && widget != null) {
            uiInput = JSFDialogFormField.getComponent(name, widget, defaultValue, options, script, scriptParams);
            JcrInputProperty inputProperty = new JcrInputProperty();
            inputProperty.setJcrPath(jcrPath);
            if (nodetype != null || mixintype != null) {
                inputProperty.setType(1);
                if (nodetype != null) {
                    inputProperty.setNodetype(nodetype);
                }
                if (mixintype != null) {
                    inputProperty.setMixintype(mixintype);
                }
            }
            uiInput.setProperty("jcrInfo", (Object)inputProperty);
            uiForm.add(uiInput);
            try {
                if (jcrNode != null && nodetype == null) {
                    if ("/node".equals(jcrPath)) {
                        uiInput.setValue(jcrNode.getName());
                    } else {
                        int index = jcrPath.indexOf("node/") + "node/".length();
                        String relativePath = jcrPath.substring(index);
                        Property prop = jcrNode.getProperty(relativePath);
                        if (prop == null) {
                            uiInput.setValue("");
                        } else if ("true".equals(multiValues)) {
                            Value[] values = prop.getValues();
                            uiInput.setValue(values[0].getString());
                            for (int i = 1; i < values.length; ++i) {
                                Value value = values[i];
                                if (uiInput instanceof UIUploadInput) {
                                    uiForm.addValue((UIInput)new UIUploadInput(name));
                                    continue;
                                }
                                if (uiInput instanceof UICheckBox) {
                                    uiForm.addValue((UIInput)new UICheckBox(name, name, value.getBoolean()));
                                    continue;
                                }
                                if (uiInput instanceof UICalendarInput) {
                                    uiForm.addValue((UIInput)new UICalendarInput(name, value.getString()));
                                    continue;
                                }
                                uiForm.addValue((UIInput)new UIStringInput(name, value.getString()));
                            }
                        } else {
                            uiInput.setValue(prop.getString());
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (uiInput != null) {
            if (editable != null && "false".equals(editable)) {
                uiInput.setEditable(false);
            } else {
                uiInput.setEditable(true);
            }
            if (visible != null && ("true".equals(visible) || "if-not-null".equals(visible) && uiInput.getValue() != null && !"".equals(uiInput.getValue()))) {
                if (selectorAction != null) {
                    if (selectorLabel.startsWith("@")) {
                        selectorLabel = selectorLabel.substring(1);
                        ResourceBundle res = (ResourceBundle)context.get("res");
                        selectorLabel = res.getString(selectorLabel);
                    }
                    String button = this.generateSelectorButton(uiForm.getFormName(), selectorAction, selectorLabel);
                    uiInput.addSelector(selectorAction, button);
                    SelectorActionListener listener = new SelectorActionListener(uiInput);
                    listener.setActionToListen(selectorAction);
                    uiForm.addActionListener((ActionListener)listener);
                    Class clazz = JSFDialogFormField.getClass(selectorAction, selectorClass);
                    try {
                        UIExoComponent uiComponent = (UIExoComponent)uiForm.getParent();
                        UIExoComponent exoComp = null;
                        exoComp = !uiComponent.hasChild(clazz) ? uiComponent.addChild(clazz) : (UIExoComponent)uiComponent.getChildComponentOfType(clazz);
                        exoComp.setRendered(false);
                        if (script != null) {
                            JSFDialogFormField.executeScript(script, exoComp, scriptParams);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new MethodInvocationException("Can not add child component", (Throwable)e, "");
                    }
                    SelectorActionClassMaps maps = JSFDialogFormField.getMaps();
                    SelectorHandlerImpl selectorHandler = new SelectorHandlerImpl(uiInput, uiForm.getClass());
                    maps.handlers.put(uiInput.getName(), selectorHandler);
                    if (selectorParams != null && script == null) {
                        String[] nonResolvedParams = StringUtils.split((String)selectorParams, (String)",");
                        maps.parameters.put(uiInput.getName(), nonResolvedParams);
                    }
                }
                if ("true".equals(multiValues)) {
                    this.manageMultiValue(context, uiForm, w, name);
                } else {
                    this.render(name, uiInput, w);
                }
            }
        } else {
            w.write("#jsfFormField( Unknow Field Name: " + name + ")");
        }
        return true;
    }

    private static SelectorActionClassMaps getMaps() {
        SessionContainer sC = SessionContainer.getInstance();
        SelectorActionClassMaps maps = (SelectorActionClassMaps)sC.getComponentInstanceOfType(SelectorActionClassMaps.class);
        if (maps == null) {
            sC.registerComponentInstance(SelectorActionClassMaps.class, (Object)new SelectorActionClassMaps());
            maps = (SelectorActionClassMaps)sC.getComponentInstanceOfType(SelectorActionClassMaps.class);
        }
        return maps;
    }

    private static Class getClass(String selectorAction, String className) {
        SelectorActionClassMaps maps = JSFDialogFormField.getMaps();
        Class mappedClass = (Class)maps.mappings.get(selectorAction);
        if (mappedClass != null) {
            return mappedClass;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        maps.mappings.put(selectorAction, clazz);
        return clazz;
    }

    private static UIInput getComponent(String key, String component, String defaultValue, String options, String script, String[] scriptParams) {
        if (component == null || TEXT.equals(component)) {
            if (defaultValue == null) {
                defaultValue = "";
            }
            UIStringInput stringInput = new UIStringInput(key, defaultValue);
            if (options == null || options.equals("")) {
                return stringInput;
            }
            StringTokenizer optionsTk = new StringTokenizer(options, ",");
            while (optionsTk.hasMoreTokens()) {
                String validatorName = optionsTk.nextToken();
                stringInput = JSFDialogFormField.addValidator(validatorName, stringInput);
            }
            return stringInput;
        }
        if (PASSWORD.equals(component)) {
            UIStringInput password = new UIStringInput(key, "");
            password.setType(1);
            return password;
        }
        if (TEXTAREA.equals(component)) {
            if (defaultValue != null && !"".equals(defaultValue)) {
                return new UITextArea(key, defaultValue);
            }
            return new UITextArea(key, "");
        }
        if (WYSIWYG.equals(component)) {
            if (defaultValue != null && !"".equals(defaultValue)) {
                return new UIWYSIWYG(key, defaultValue, options);
            }
            return new UIWYSIWYG(key, "", options);
        }
        if (CALENDAR.equals(component)) {
            UICalendarInput uiCalendar = new UICalendarInput(key, "");
            if (defaultValue != null && !"".equals(defaultValue)) {
                uiCalendar.setText(defaultValue);
            }
            if (options != null && !options.equals("") && options.equalsIgnoreCase(DISPLAY_TIME)) {
                uiCalendar.setDisplayTime(true);
            }
            return uiCalendar;
        }
        if (UPLOAD.equals(component)) {
            return new UIUploadInput(key);
        }
        if (IMAGE_UPLOAD.equals(component)) {
            UIImageUploadInput uploadInput = null;
            if (options != null && !"".equals(options)) {
                StringTokenizer optionsTk = new StringTokenizer(options, ",");
                ArrayList<String> optionsList = new ArrayList<String>();
                while (optionsTk.hasMoreTokens()) {
                    String value = optionsTk.nextToken();
                    optionsList.add(value);
                }
                uploadInput = new UIImageUploadInput(key, optionsList);
            } else {
                uploadInput = new UIImageUploadInput(key);
            }
            return uploadInput;
        }
        if (SELECTBOX.equals(component)) {
            ArrayList<SelectItem> optionsList = null;
            UISelectBox selectBox = new UISelectBox(key, "", null);
            if (script != null) {
                JSFDialogFormField.executeScript(script, selectBox, scriptParams);
            } else if (options != null && !"".equals(options)) {
                StringTokenizer optionsTk = new StringTokenizer(options, ",");
                optionsList = new ArrayList<SelectItem>(3);
                while (optionsTk.hasMoreTokens()) {
                    String value = optionsTk.nextToken();
                    optionsList.add(new SelectItem(value, value));
                }
                selectBox.setOptions(optionsList);
                selectBox.setUpdateOnChangeAction(DUMMY_ACTION);
            }
            if (defaultValue != null && !"".equals(defaultValue)) {
                selectBox.setDefaultValue(defaultValue);
                selectBox.reset();
            }
            return selectBox;
        }
        return null;
    }

    private static void executeScript(String script, Object o, String[] params) {
        PortalContainer pC = PortalContainer.getInstance();
        ScriptService scriptService = (ScriptService)pC.getComponentInstanceOfType(ScriptService.class);
        try {
            CmsScript dialogScript = scriptService.getScript(script);
            if (params != null) {
                dialogScript.setParams(params);
            }
            dialogScript.execute(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static UIStringInput addValidator(String validatorName, UIStringInput param) {
        if (validatorName.equals(EMPTY_FEILD_VALIDATOR)) {
            return param.addValidator(EmptyFieldValidator.class);
        }
        if (validatorName.equals(NAME_VALIDATOR)) {
            return param.addValidator(NameValidator.class);
        }
        if (validatorName.equals(NUMBER_FORMAT_VALIDATOR)) {
            return param.addValidator(NumberFormatValidator.class);
        }
        if (validatorName.equals(EMAIL_ADDRESS_VALIDATOR)) {
            return param.addValidator(EmailAddressValidator.class);
        }
        if (validatorName.equals(IDENTIFIER_VALIDATOR)) {
            return param.addValidator(IdentifierValidator.class);
        }
        if (validatorName.equals(QUARTZ_CRON_EXPRESSION_VALIDATOR)) {
            return param.addValidator(QuartzCronExpressionValidator.class);
        }
        return param;
    }
}

