/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.signer.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.applet.util.Base64Encoder;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.signer.DigitalSignatureService;
import org.exoplatform.services.signer.impl.BaseDigitalSigner;

public class DigitalSignatureServiceImpl
implements DigitalSignatureService {
    private Log logger;
    private Map<String, BaseDigitalSigner> signers = new HashMap<String, BaseDigitalSigner>();

    public DigitalSignatureServiceImpl(InitParams params, LogService logSvr) {
        this.logger = logSvr.getLog(DigitalSignatureService.class);
    }

    public String computeDigest(Node node) throws Exception {
        String nodeTypeName = node.getPrimaryNodeType().getName();
        BaseDigitalSigner signer = this.signers.get(nodeTypeName);
        if (signer != null) {
            String user = "<user>";
            String algorithm = this.getDigestMethod(user, node);
            byte[] hash = signer.computeDigest(node, algorithm);
            return this.base64Encode(hash);
        }
        throw new Exception("Cannot handle nodeType: " + nodeTypeName);
    }

    private String base64Encode(byte[] hash) {
        String result = null;
        try {
            Base64Encoder encoder = new Base64Encoder();
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            encoder.encode(hash, 0, hash.length, (OutputStream)ostream);
            result = ostream.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public String getDigestMethod(String user, Node node) {
        String algorithm = "SHA-1";
        this.logger.debug((Object)("No configured digest algorithm is obtained (TODO). Using: " + algorithm));
        return algorithm;
    }

    public String[] getSupportedNodeTypeNames() {
        Set<String> keys = this.signers.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public void addDigitalSigner(ComponentPlugin plugin) {
        BaseDigitalSigner signer = (BaseDigitalSigner)plugin;
        for (String supportedNodeTypeName : signer.getNodeTypeNames()) {
            this.signers.put(supportedNodeTypeName, signer);
        }
    }

    public boolean hasNodeTypeSupport(String nodeType) {
        return this.signers.containsKey(nodeType);
    }

    public void addSignature(Node node, String encodedSignature, String encodedCertChain) throws RepositoryException {
        node.addMixin("exo:xmldsig");
        node.setProperty("exo:signature", encodedSignature);
        node.save();
    }
}

