/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.signer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public class JCEUtil {
    private static JCEUtil instance;
    private static final int READ_BLOCK_SIZE = 4096;
    private static String jceProvider;

    private JCEUtil() {
        try {
            Class<?> clazz = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            Provider prov = (Provider)clazz.newInstance();
            Security.addProvider(prov);
            jceProvider = prov.getName();
        }
        catch (Exception e) {
            jceProvider = null;
        }
    }

    public static JCEUtil getInstance() {
        if (instance == null) {
            instance = new JCEUtil();
        }
        return instance;
    }

    public byte[] calculateDigest(InputStream data, String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        int read;
        MessageDigest md = jceProvider == null ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, jceProvider);
        byte[] buffer = new byte[4096];
        while ((read = data.read(buffer)) != -1) {
            md.update(buffer, 0, read);
        }
        buffer = null;
        return md.digest();
    }
}

