/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.signer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.signer.impl.BaseDigitalSigner;

public class NTFileSigner
extends BaseDigitalSigner {
    public NTFileSigner(InitParams params, LogService logSrv) {
        super(params, logSrv);
    }

    public byte[] computeDigest(Node fileNode, String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        byte[] digest = null;
        try {
            Node jcrContent = fileNode.getNode("jcr:content");
            InputStream data = jcrContent.getProperty("jcr:data").getStream();
            digest = this.calculateDigest(data, algorithm);
            StringBuffer hexDigest = new StringBuffer();
            for (byte octet : digest) {
                if (hexDigest.length() > 0) {
                    hexDigest.append(' ');
                }
                hexDigest.append(Integer.toHexString(octet));
            }
            this.logger.debug((Object)("[" + fileNode.getPath() + "] calculated digest (using [" + algorithm + "] algorithm) is: " + hexDigest.toString()));
        }
        catch (RepositoryException e) {
            this.logger.error((Object)"Unexpected repository exception", (Throwable)e);
        }
        return digest;
    }
}

