/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.instantiation.ClassLoaderUtil;

public class JbpmConfiguration {
    static Properties properties = null;
    private static final Log log = LogFactory.getLog(JbpmConfiguration.class);

    private JbpmConfiguration() {
    }

    private static Properties getProperties() {
        if (properties == null) {
            properties = ClassLoaderUtil.getProperties("jbpm.properties", "org/jbpm");
            for (String string : properties.keySet()) {
                log.debug((Object)(string + "=" + properties.getProperty(string)));
            }
        }
        return properties;
    }

    public static String getString(String key) {
        return JbpmConfiguration.getProperties().getProperty(key);
    }

    public static String getString(String key, String defaultValue) {
        return JbpmConfiguration.getProperties().getProperty(key, defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        long value = defaultValue;
        String valueText = JbpmConfiguration.getProperties().getProperty(key);
        if (valueText != null) {
            try {
                value = Long.parseLong(valueText);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("jbpm configuration property '" + key + "' is not parsable to a long : '" + valueText + "'", e);
            }
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        boolean value = defaultValue;
        String valueText = JbpmConfiguration.getProperties().getProperty(key);
        if (valueText != null) {
            try {
                value = new Boolean(valueText);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("jbpm configuration property '" + key + "' is not parsable to a long : '" + valueText + "'", e);
            }
        }
        return value;
    }

    public static Object getObject(String key) {
        return JbpmConfiguration.getObject(key, null);
    }

    public static Object getObject(String key, Object defaultValue) {
        Object instance = null;
        String className = JbpmConfiguration.getProperties().getProperty(key);
        if (className == null) {
            instance = defaultValue;
        } else {
            try {
                Class clazz = ClassLoaderUtil.loadClass(className);
                instance = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("couldn't instantiate class " + className + " configured in property " + key);
            }
        }
        return instance;
    }
}

