/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jbpm.calendar.BusinessCalendar;

public class Duration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long WEEK = 604800000L;
    private static final long MONTH = 2592000000L;
    private static final long YEAR = 31536000000L;
    private static long BUSINESS_DAY = 0L;
    private static long BUSINESS_WEEK = 0L;
    private static long BUSINESS_MONTH = 0L;
    private static long BUSINESS_YEAR = 0L;
    private static Map units;
    long milliseconds = 0L;
    boolean isBusinessTime = false;

    Duration() {
    }

    public Duration(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public Duration(Duration duration) {
        this.milliseconds = duration.milliseconds;
        this.isBusinessTime = duration.isBusinessTime;
    }

    public Duration(String duration) {
        if (duration == null) {
            throw new NullPointerException("duration is null");
        }
        int separatorIndex = duration.indexOf(32);
        if (separatorIndex == -1) {
            throw new IllegalArgumentException("improper format of duration '" + duration + "'");
        }
        String quantityText = duration.substring(0, separatorIndex).trim().toLowerCase();
        String unitText = duration.substring(separatorIndex + 1).trim().toLowerCase();
        if (unitText.startsWith("business")) {
            this.isBusinessTime = true;
        }
        double amount = Double.parseDouble(quantityText);
        Long unit = (Long)units.get(unitText);
        this.milliseconds = (long)(amount * (double)unit.longValue());
    }

    static {
        Properties businessCalendarProperties = BusinessCalendar.getBusinessCalendarProperties();
        String businessDayText = businessCalendarProperties.getProperty("business.day.expressed.in.hours");
        String businessWeekText = businessCalendarProperties.getProperty("business.week.expressed.in.hours");
        String businessMonthText = businessCalendarProperties.getProperty("business.month.expressed.in.business.days");
        String businessYearText = businessCalendarProperties.getProperty("business.year.expressed.in.business.days");
        BUSINESS_DAY = (long)(Double.parseDouble(businessDayText) * 3600000.0);
        BUSINESS_WEEK = (long)(Double.parseDouble(businessWeekText) * 3600000.0);
        BUSINESS_MONTH = (long)(Double.parseDouble(businessMonthText) * (double)BUSINESS_DAY);
        BUSINESS_YEAR = (long)(Double.parseDouble(businessYearText) * (double)BUSINESS_DAY);
        units = null;
        units = new HashMap();
        units.put("second", new Long(1000L));
        units.put("seconds", new Long(1000L));
        units.put("business second", new Long(1000L));
        units.put("business seconds", new Long(1000L));
        units.put("minute", new Long(60000L));
        units.put("minutes", new Long(60000L));
        units.put("business minute", new Long(60000L));
        units.put("business minutes", new Long(60000L));
        units.put("hour", new Long(3600000L));
        units.put("hours", new Long(3600000L));
        units.put("business hour", new Long(3600000L));
        units.put("business hours", new Long(3600000L));
        units.put("day", new Long(86400000L));
        units.put("days", new Long(86400000L));
        units.put("business day", new Long(BUSINESS_DAY));
        units.put("business days", new Long(BUSINESS_DAY));
        units.put("week", new Long(604800000L));
        units.put("weeks", new Long(604800000L));
        units.put("business week", new Long(BUSINESS_WEEK));
        units.put("business weeks", new Long(BUSINESS_WEEK));
        units.put("month", new Long(2592000000L));
        units.put("months", new Long(2592000000L));
        units.put("business month", new Long(BUSINESS_MONTH));
        units.put("business months", new Long(BUSINESS_MONTH));
        units.put("year", new Long(31536000000L));
        units.put("years", new Long(31536000000L));
        units.put("business year", new Long(BUSINESS_YEAR));
        units.put("business years", new Long(BUSINESS_YEAR));
    }
}

