/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.module.exe.ModuleInstance;

public class ContextInstance
extends ModuleInstance {
    private static final long serialVersionUID = 1L;
    protected Map tokenVariableMaps = null;
    protected transient Map transientVariables = null;

    public void createVariable(String name, Object value) {
        this.createVariable(name, value, this.getRootToken());
    }

    public void createVariable(String name, Object value, Token token) {
        TokenVariableMap tokenVariableMap = this.getOrCreateTokenVariableMap(token);
        tokenVariableMap.createVariableInstance(name, value);
    }

    public Map getVariables() {
        return this.getVariables(this.getRootToken());
    }

    public Map getVariables(Token token) {
        HashMap variables = new HashMap();
        TokenVariableMap tokenVariableMap = this.getTokenVariableMap(token);
        if (tokenVariableMap != null) {
            tokenVariableMap.collectAllVariables(variables);
        }
        return variables;
    }

    public void addVariables(Map variables) {
        this.addVariables(variables, this.getRootToken());
    }

    public void addVariables(Map variables, Token token) {
        TokenVariableMap tokenVariableMap = this.getOrCreateTokenVariableMap(token);
        tokenVariableMap.addVariables(variables);
    }

    public Object getVariable(String name) {
        return this.getVariable(name, this.getRootToken());
    }

    public Object getVariable(String name, Token token) {
        Object variable = null;
        TokenVariableMap tokenVariableMap = this.getTokenVariableMap(token);
        if (tokenVariableMap != null) {
            variable = tokenVariableMap.getVariable(name);
        }
        return variable;
    }

    public Object getLocalVariable(String name, Token token) {
        VariableInstance variableInstance;
        TokenVariableMap tokenVariableMap;
        Object variable = null;
        if (this.tokenVariableMaps != null && this.tokenVariableMaps.containsKey(token) && (tokenVariableMap = (TokenVariableMap)this.tokenVariableMaps.get(token)) != null && (variableInstance = tokenVariableMap.getVariableInstance(name)) != null) {
            variable = variableInstance.getValue();
        }
        return variable;
    }

    public void setVariable(String name, Object value) {
        this.setVariable(name, value, this.getRootToken());
    }

    public void setVariable(String name, Object value, Token token) {
        TokenVariableMap tokenVariableMap = this.getOrCreateTokenVariableMap(token);
        tokenVariableMap.setVariable(name, value);
    }

    public boolean hasVariable(String name) {
        return this.hasVariable(name, this.getRootToken());
    }

    public boolean hasVariable(String name, Token token) {
        boolean hasVariable = false;
        TokenVariableMap tokenVariableMap = this.getTokenVariableMap(token);
        if (tokenVariableMap != null) {
            hasVariable = tokenVariableMap.hasVariable(name);
        }
        return hasVariable;
    }

    public void deleteVariable(String name) {
        this.deleteVariable(name, this.getRootToken());
    }

    public void deleteVariable(String name, Token token) {
        TokenVariableMap tokenVariableMap = this.getTokenVariableMap(token);
        if (tokenVariableMap != null) {
            tokenVariableMap.deleteVariable(name);
        }
    }

    public Object getTransientVariable(String name) {
        Object transientVariable = null;
        if (this.transientVariables != null) {
            transientVariable = this.transientVariables.get(name);
        }
        return transientVariable;
    }

    public void setTransientVariable(String name, Object value) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap();
        }
        this.transientVariables.put(name, value);
    }

    public boolean hasTransientVariable(String name) {
        if (this.transientVariables == null) {
            return false;
        }
        return this.transientVariables.containsKey(name);
    }

    public Map getTransientVariables() {
        return this.transientVariables;
    }

    public void setTransientVariables(Map transientVariables) {
        this.transientVariables = transientVariables;
    }

    public void deleteTransientVariable(String name) {
        if (this.transientVariables == null) {
            return;
        }
        this.transientVariables.remove(name);
    }

    Token getRootToken() {
        return this.processInstance.getRootToken();
    }

    TokenVariableMap getOrCreateTokenVariableMap(Token token) {
        TokenVariableMap tokenVariableMap = null;
        if (this.tokenVariableMaps == null) {
            this.tokenVariableMaps = new HashMap();
        }
        if (this.tokenVariableMaps.containsKey(token)) {
            tokenVariableMap = (TokenVariableMap)this.tokenVariableMaps.get(token);
        } else {
            tokenVariableMap = new TokenVariableMap(token, this);
            this.tokenVariableMaps.put(token, tokenVariableMap);
            TokenVariableMap parentVariableMap = null;
            for (Token parent = token.getParent(); parent != null; parent = parent.getParent()) {
                if (this.tokenVariableMaps.containsKey(parent)) continue;
                parentVariableMap = new TokenVariableMap(parent, this);
                this.tokenVariableMaps.put(parent, parentVariableMap);
            }
        }
        return tokenVariableMap;
    }

    TokenVariableMap getTokenVariableMap(Token token) {
        TokenVariableMap tokenVariableMap = null;
        if (this.tokenVariableMaps != null) {
            if (this.tokenVariableMaps.containsKey(token)) {
                tokenVariableMap = (TokenVariableMap)this.tokenVariableMaps.get(token);
            } else if (!token.isRoot()) {
                tokenVariableMap = this.getTokenVariableMap(token.getParent());
            }
        }
        return tokenVariableMap;
    }
}

