/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.jbpm.context.exe.Converter;

public class SerializableToStringConverter
implements Converter {
    private static final long serialVersionUID = 1L;

    public boolean supports(Class clazz) {
        return Serializable.class.isAssignableFrom(clazz);
    }

    private Object getBase64() {
        try {
            return new Base64();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("for storing serializable objects as variables, you need to put the commons-codec-x.x.jar in the classpath", e);
        }
    }

    public Object convert(Object o) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("couldn't serialize '" + o + "'", e);
        }
        bytes = ((Base64)this.getBase64()).encode(bytes);
        return new String(bytes);
    }

    public Object revert(Object o) {
        byte[] bytes = ((String)o).getBytes();
        bytes = ((Base64)this.getBase64()).decode(bytes);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't deserialize object", e);
        }
    }
}

