/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.scheduler.exe.SchedulerInstance;
import org.jbpm.scheduler.exe.Timer;

public class SchedulerSession {
    JbpmSession jbpmSession = null;
    Session session = null;
    private static final String findTimersByDueDate = "select ti from org.jbpm.scheduler.exe.Timer as ti where ti.exception is null order by ti.dueDate asc";
    private static final String findFailedTimers = "select ti from org.jbpm.scheduler.exe.Timer as ti where ti.exception is not null order by ti.dueDate asc";
    private static final String deleteTimersQuery = "delete from org.jbpm.scheduler.exe.Timer where name = :timerName  and token = :token";
    private static final String deleteTimersForProcessInstanceQuery = "delete from org.jbpm.scheduler.exe.Timer where processInstance = :processInstance";
    private static final Log log = LogFactory.getLog(SchedulerSession.class);

    public SchedulerSession(JbpmSession jbpmSession) {
        this.jbpmSession = jbpmSession;
        this.session = jbpmSession.getSession();
    }

    public void saveTimer(Timer timer) {
        try {
            this.session.save((Object)timer);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't save timer '" + timer + "' to the database", e);
        }
    }

    public void deleteTimer(Timer timer) {
        try {
            this.session.delete((Object)timer);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't delete timer '" + timer + "' from the database", e);
        }
    }

    public Iterator findTimersByDueDate() {
        try {
            return this.session.createQuery(findTimersByDueDate).iterate();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't find timers from the database", e);
        }
    }

    public Iterator findFailedTimers() {
        try {
            return this.session.createQuery(findFailedTimers).iterate();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't find failed timers from the database", e);
        }
    }

    void saveTimers(ProcessInstance processInstance) {
        SchedulerInstance schedulerInstance = processInstance.getSchedulerInstance();
        if (schedulerInstance.isProcessEnded()) {
            this.cancelTimersForProcessInstance(processInstance);
        } else {
            for (Timer timer : schedulerInstance.getScheduledTimers()) {
                log.debug((Object)("saving timer " + timer));
                this.session.save((Object)timer);
            }
            for (SchedulerInstance.CancelledTimer cancelledTimer : schedulerInstance.getCancelledTimerNames()) {
                this.cancelTimers(cancelledTimer);
            }
        }
    }

    public void cancelTimers(SchedulerInstance.CancelledTimer cancelledTimer) {
        try {
            Query query = this.session.createQuery(deleteTimersQuery);
            query.setString("timerName", cancelledTimer.getTimerName());
            query.setEntity("token", (Object)cancelledTimer.getToken());
            query.executeUpdate();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't delete timers '" + cancelledTimer.getTimerName() + "' on token '" + cancelledTimer.getToken().getId() + "' from the database", e);
        }
    }

    public void cancelTimersForProcessInstance(ProcessInstance processInstance) {
        try {
            Query query = this.session.createQuery(deleteTimersForProcessInstanceQuery);
            query.setEntity("processInstance", (Object)processInstance);
            query.executeUpdate();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.jbpmSession.handleException();
            throw new RuntimeException("couldn't delete timers for process instance '" + processInstance + "'", e);
        }
    }
}

