/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.util.HashMap;
import java.util.Properties;
import org.jbpm.context.exe.Converter;
import org.jbpm.instantiation.ClassLoaderUtil;

public class Converters {
    static HashMap convertersByClassNames = null;
    static HashMap convertersByDatabaseId = null;
    static HashMap convertersIds = null;

    public static Converter getConverterByClassName(String className) {
        Converters.initConvertionMaps();
        Converter converter = (Converter)convertersByClassNames.get(className);
        if (converter == null) {
            throw new RuntimeException("converter '" + className + "' is not declared in jbpm.converter.properties");
        }
        return converter;
    }

    public static Converter getConverterByDatabaseId(String converterDatabaseId) {
        Converters.initConvertionMaps();
        return (Converter)convertersByDatabaseId.get(converterDatabaseId);
    }

    public static String getConverterId(Converter converter) {
        Converters.initConvertionMaps();
        return (String)convertersIds.get(converter);
    }

    static void initConvertionMaps() {
        if (convertersByClassNames == null) {
            Properties converterProperties = ClassLoaderUtil.getProperties("jbpm.converter.properties", "org/jbpm/db/hibernate");
            convertersByClassNames = new HashMap();
            convertersByDatabaseId = new HashMap();
            convertersIds = new HashMap();
            for (String string : converterProperties.keySet()) {
                if (string.length() != 1) {
                    throw new RuntimeException("converter-ids must be of length 1 (to be stored in a char)");
                }
                if (convertersByDatabaseId.containsKey(string)) {
                    throw new RuntimeException("duplicate converter id : '" + string + "'");
                }
                String converterClassName = converterProperties.getProperty(string);
                try {
                    Class converterClass = ClassLoaderUtil.loadClass(converterClassName);
                    Converter converter = (Converter)converterClass.newInstance();
                    convertersByClassNames.put(converterClassName, converter);
                    convertersByDatabaseId.put(string, converter);
                    convertersIds.put(converter, string);
                }
                catch (Exception e) {
                    throw new RuntimeException("couldn't instantiate converter '" + converterClassName + "'");
                }
            }
        }
    }
}

