/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.jmx;

import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jbpm.db.JbpmSessionFactory;
import org.jbpm.db.jmx.JbpmServiceMBean;

public class JbpmService
extends ServiceMBeanSupport
implements JbpmServiceMBean {
    String jndiName = null;

    protected void startService() throws Exception {
        this.log.debug((Object)("starting jbpmSessionFactory for '" + this.jndiName + "'..."));
        JbpmSessionFactory jbpmSessionFactory = JbpmSessionFactory.buildJbpmSessionFactory();
        InitialContext rootCtx = new InitialContext();
        Name fullName = rootCtx.getNameParser("").parse(this.jndiName);
        this.log.info((Object)("binding JbpmSessionFactory '" + this.jndiName + "' into JNDI..."));
        NonSerializableFactory.rebind((Name)fullName, (Object)jbpmSessionFactory, (boolean)true);
    }

    protected void stopService() throws Exception {
        try {
            InitialContext rootCtx = new InitialContext();
            rootCtx.unbind(this.jndiName);
            NonSerializableFactory.unbind((String)this.jndiName);
        }
        catch (NamingException e) {
            this.log.error((Object)"Failed to unbind jbpmSessionFactory", (Throwable)e);
        }
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }
}

