/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.file.def;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.bytes.ByteArray;
import org.jbpm.module.def.ModuleDefinition;
import org.jbpm.module.exe.ModuleInstance;

public class FileDefinition
extends ModuleDefinition {
    private static final long serialVersionUID = 1L;
    static String rootDir = JbpmConfiguration.getString("jbpm.files.dir");
    private String dir = null;
    private Map processFiles = null;
    private static final int BUFFER_SIZE = 512;
    private static final Log log = LogFactory.getLog(FileDefinition.class);

    public ModuleInstance createInstance() {
        return null;
    }

    public void addFile(String name, byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        this.addFile(name, bais);
    }

    public void addFile(String name, InputStream is) {
        try {
            if (this.isStoredOnFileSystem()) {
                this.storeFileOnFileSystem(name, is);
            } else {
                this.storeFileInDb(name, is);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("file '" + name + "' could not be stored", e);
        }
    }

    private void storeFileOnFileSystem(String name, InputStream is) throws FileNotFoundException, IOException {
        String fileName = this.getFilePath(name);
        log.trace((Object)("storing file '" + name + "' on file system to '" + fileName + "'"));
        FileOutputStream fos = new FileOutputStream(fileName);
        FileDefinition.transfer(is, fos);
        fos.close();
    }

    private void storeFileInDb(String name, InputStream is) throws IOException {
        if (this.processFiles == null) {
            this.processFiles = new HashMap();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        log.trace((Object)("preparing file '" + name + "' for storage in the database"));
        FileDefinition.transfer(is, baos);
        this.processFiles.put(name, new ByteArray(name, baos.toByteArray()));
    }

    public InputStream getInputStream(String name) {
        InputStream inputStream = null;
        try {
            inputStream = this.isStoredOnFileSystem() ? this.getInputStreamFromFileSystem(name) : this.getInputStreamFromDb(name);
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't get inputstream for file '" + name + "'", e);
        }
        return inputStream;
    }

    public Map getInputStreamMap() {
        HashMap<String, InputStream> result = new HashMap<String, InputStream>();
        if (this.processFiles != null) {
            for (String name : this.processFiles.keySet()) {
                result.put(name, this.getInputStream(name));
            }
        }
        return result;
    }

    public Map getBytesMap() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        if (this.processFiles != null) {
            for (String name : this.processFiles.keySet()) {
                result.put(name, this.getBytes(name));
            }
        }
        return result;
    }

    private InputStream getInputStreamFromFileSystem(String name) throws FileNotFoundException {
        FileInputStream inputStream = null;
        String fileName = this.getFilePath(name);
        log.trace((Object)("loading file '" + name + "' from file system '" + fileName + "'"));
        inputStream = new FileInputStream(fileName);
        return inputStream;
    }

    private InputStream getInputStreamFromDb(String name) {
        ByteArrayInputStream inputStream = null;
        log.trace((Object)("loading file '" + name + "' from database"));
        ByteArray byteArray = this.getByteArray(name);
        inputStream = new ByteArrayInputStream(byteArray.getBytes());
        return inputStream;
    }

    public byte[] getBytes(String name) {
        byte[] bytes = null;
        try {
            bytes = this.isStoredOnFileSystem() ? this.getBytesFromFileSystem(name) : this.getBytesFromDb(name);
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't get value for file '" + name + "'", e);
        }
        return bytes;
    }

    private byte[] getBytesFromFileSystem(String name) throws IOException {
        byte[] bytes = null;
        InputStream in = this.getInputStreamFromFileSystem(name);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileDefinition.transfer(in, out);
        bytes = out.toByteArray();
        return bytes;
    }

    private byte[] getBytesFromDb(String name) {
        ByteArray byteArray = this.getByteArray(name);
        byte[] bytes = byteArray.getBytes();
        return bytes;
    }

    private ByteArray getByteArray(String name) {
        ByteArray byteArray = this.processFiles != null ? this.processFiles.get(name) : null;
        if (byteArray == null) {
            throw new RuntimeException("file '" + name + "' not found in db");
        }
        return byteArray;
    }

    private boolean isStoredOnFileSystem() {
        boolean isStoredOnFileSystem;
        boolean bl = isStoredOnFileSystem = rootDir != null;
        if (isStoredOnFileSystem && this.dir == null) {
            this.dir = this.findNewDirName();
            new File(rootDir + "/" + this.dir).mkdirs();
        }
        return isStoredOnFileSystem;
    }

    private String findNewDirName() {
        String newDirName = "files-1";
        File parentFile = new File(rootDir);
        if (parentFile.exists()) {
            String[] children = parentFile.list();
            ArrayList<Object> fileNames = new ArrayList();
            if (children != null) {
                fileNames = new ArrayList<String>(Arrays.asList(children));
            }
            int seqNr = 1;
            while (fileNames.contains(newDirName)) {
                newDirName = "files-" + ++seqNr;
            }
        }
        return newDirName;
    }

    private String getFilePath(String name) {
        String filePath = rootDir + "/" + this.dir + "/" + name;
        new File(filePath).getParentFile().mkdirs();
        return filePath;
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buffer = new byte[512];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
            bytesRead = in.read(buffer);
        }
        return total;
    }
}

