/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.Map;
import org.dom4j.Element;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Action
implements Parsable,
Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected String name = null;
    protected boolean isPropagationAllowed = true;
    protected Action referencedAction = null;
    protected Delegation actionDelegation = null;
    protected Event event = null;
    protected ProcessDefinition processDefinition = null;

    public Action() {
    }

    public Action(Delegation actionDelegate) {
        this.actionDelegation = actionDelegate;
    }

    public String toString() {
        String toString = null;
        if (this.name != null) {
            toString = "action[" + this.name + "]";
        } else if (this.actionDelegation != null && this.actionDelegation.getClassName() != null) {
            String className = this.actionDelegation.getClassName();
            toString = className.substring(className.lastIndexOf(46) + 1);
        } else {
            String className = this.getClass().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            toString = this.name != null ? className + "(" + this.name + ")" : className + "(" + Integer.toHexString(System.identityHashCode(this)) + ")";
        }
        return toString;
    }

    public void read(Element actionElement, JpdlXmlReader jpdlReader) {
        if (actionElement.attribute("ref-name") != null) {
            jpdlReader.addUnresolvedActionReference(actionElement, this);
        } else if (actionElement.attribute("class") != null) {
            this.actionDelegation = new Delegation();
            this.actionDelegation.read(actionElement, jpdlReader);
            String acceptPropagatedEvents = actionElement.attributeValue("accept-propagated-events");
            if ("false".equalsIgnoreCase(acceptPropagatedEvents) || "no".equalsIgnoreCase(acceptPropagatedEvents)) {
                this.isPropagationAllowed = false;
            }
        } else {
            jpdlReader.addWarning("action does not have class nor ref-name attribute " + actionElement.asXML());
        }
    }

    public void write(Element actionElement) {
        if (this.actionDelegation != null) {
            this.actionDelegation.write(actionElement);
        }
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        if (this.referencedAction != null) {
            this.referencedAction.execute(executionContext);
        } else {
            ActionHandler actionHandler = (ActionHandler)this.actionDelegation.getInstance();
            actionHandler.execute(executionContext);
        }
    }

    public void setName(String name) {
        if (this.processDefinition != null) {
            Map actionMap = this.processDefinition.getActions();
            if (this.name != name && actionMap != null) {
                actionMap.remove(this.name);
                actionMap.put(name, this);
            }
        }
        this.name = name;
    }

    public boolean acceptsPropagatedEvents() {
        return this.isPropagationAllowed;
    }

    public boolean isPropagationAllowed() {
        return this.isPropagationAllowed;
    }

    public void setPropagationAllowed(boolean isPropagationAllowed) {
        this.isPropagationAllowed = isPropagationAllowed;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Event getEvent() {
        return this.event;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public Delegation getActionDelegation() {
        return this.actionDelegation;
    }

    public void setActionDelegation(Delegation instantiatableDelegate) {
        this.actionDelegation = instantiatableDelegate;
    }

    public Action getReferencedAction() {
        return this.referencedAction;
    }

    public void setReferencedAction(Action referencedAction) {
        this.referencedAction = referencedAction;
    }
}

