/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.dom4j.Element;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.action.Script;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Fork
extends Node
implements Parsable {
    private static final long serialVersionUID = 1L;
    private Script script = null;

    public Fork() {
    }

    public Fork(String name) {
        super(name);
    }

    public void read(Element forkElement, JpdlXmlReader jpdlReader) {
        Element scriptElement = forkElement.element("script");
        if (scriptElement != null) {
            this.script = new Script();
            this.script.read(scriptElement, jpdlReader);
        }
    }

    public void execute(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        Node forkNode = token.getNode();
        Collection<Object> transitionNames = null;
        ArrayList<ForkedToken> forkedTokens = new ArrayList<ForkedToken>();
        if (this.script == null) {
            transitionNames = forkNode.getLeavingTransitionsMap().keySet();
        } else {
            Object result;
            Map outputMap = this.script.eval(token);
            if (outputMap.size() == 1 && (result = outputMap.values().iterator().next()) instanceof Collection) {
                transitionNames = (Collection)result;
            }
            if (transitionNames == null) {
                throw new RuntimeException("script for fork '" + this.name + "' should produce one collection (in one writable variable): " + transitionNames);
            }
        }
        for (String transitionName : transitionNames) {
            forkedTokens.add(this.createForkedToken(token, transitionName));
        }
        for (ForkedToken forkedToken : forkedTokens) {
            Token childToken = forkedToken.token;
            String leavingTransitionName = forkedToken.leavingTransitionName;
            ExecutionContext childExecutionContext = new ExecutionContext(childToken);
            if (leavingTransitionName != null) {
                this.leave(childExecutionContext, leavingTransitionName);
                continue;
            }
            this.leave(childExecutionContext);
        }
    }

    protected ForkedToken createForkedToken(Token parent, String transitionName) {
        Token childToken = new Token(parent, this.getTokenName(parent, transitionName));
        JbpmSession jbpmSession = JbpmSession.getCurrentJbpmSession();
        if (jbpmSession != null) {
            jbpmSession.getSession().save((Object)childToken);
        }
        ForkedToken forkedToken = null;
        forkedToken = new ForkedToken(childToken, transitionName);
        return forkedToken;
    }

    protected String getTokenName(Token parent, String transitionName) {
        String tokenName = null;
        if (transitionName != null) {
            if (!parent.hasChild(transitionName)) {
                tokenName = transitionName;
            } else {
                int i = 2;
                tokenName = transitionName + Integer.toString(i);
                while (parent.hasChild(tokenName)) {
                    tokenName = transitionName + Integer.toString(++i);
                }
            }
        } else {
            int size = parent.getChildren() != null ? parent.getChildren().size() + 1 : 1;
            tokenName = Integer.toString(size);
        }
        return tokenName;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }

    private static class ForkedToken {
        Token token = null;
        String leavingTransitionName = null;

        public ForkedToken(Token token, String leavingTransitionName) {
            this.token = token;
            this.leavingTransitionName = leavingTransitionName;
        }
    }
}

