/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Map;
import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.security.Authentication;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;

public class StartState
extends Node {
    private static final long serialVersionUID = 1L;
    public Swimlane initiatorSwimlane = null;
    public static final String[] supportedEventTypes = new String[]{"node-leave", "after-signal"};

    public StartState() {
    }

    public StartState(String name) {
        super(name);
    }

    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public void read(Element startStateElement, JpdlXmlReader jpdlReader) {
        Element startTaskElement;
        String swimlaneName = startStateElement.attributeValue("swimlane");
        if (swimlaneName != null) {
            TaskMgmtDefinition taskMgmtDefinition = jpdlReader.getProcessDefinition().getTaskMgmtDefinition();
            this.initiatorSwimlane = taskMgmtDefinition.getSwimlane(swimlaneName);
        }
        if ((startTaskElement = startStateElement.element("task")) != null) {
            jpdlReader.readStartStateTask(startTaskElement, this);
        }
    }

    public void write(Element nodeElement) {
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        if (this.initiatorSwimlane != null) {
            SwimlaneInstance initiatorSwimlaneInstance = executionContext.getTaskMgmtInstance().getSwimlaneInstance(this.initiatorSwimlane.getName());
            String initiatorActorId = Authentication.getAuthenticatedActorId();
            initiatorSwimlaneInstance.setActorId(initiatorActorId);
        }
        super.leave(executionContext, transition);
    }

    public void execute(ExecutionContext executionContext) {
        throw new UnsupportedOperationException("illegal operation : its not possible to arrive in a start-state");
    }

    public Transition addArrivingTransition(Transition t) {
        throw new UnsupportedOperationException("illegal operation : its not possible to add a transition that is arriving in a start state");
    }

    public void setArrivingTransitions(Map arrivingTransitions) {
        if (arrivingTransitions != null && arrivingTransitions.size() > 0) {
            throw new UnsupportedOperationException("illegal operation : its not possible to set a non-empty map in the arriving transitions of a start state");
        }
    }
}

