/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.instantiation.Instantiator;

public class XmlInstantiator
implements Instantiator {
    private static final Class[] parameterTypes = new Class[]{Element.class};
    private static final Log log = LogFactory.getLog(XmlInstantiator.class);

    public Object instantiate(Class clazz, String configuration) {
        Object newInstance = null;
        try {
            Element configurationElement = this.parseConfiguration(configuration);
            Constructor constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            newInstance = constructor.newInstance(configurationElement);
        }
        catch (Exception e) {
            log.error((Object)("couldn't instantiate '" + clazz.getName() + "'"), (Throwable)e);
            throw new RuntimeException(e);
        }
        return newInstance;
    }

    protected Element parseConfiguration(String configuration) {
        Element element = null;
        try {
            element = DocumentHelper.parseText((String)("<action>" + configuration + "</action>")).getRootElement();
        }
        catch (DocumentException e) {
            log.error((Object)("couldn't parse bean configuration : " + configuration), (Throwable)e);
            throw new RuntimeException(e);
        }
        return element;
    }
}

